% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setHyperPars.R
\name{setHyperPars}
\alias{setHyperPars}
\title{Set the hyperparameters of a learner object.}
\usage{
setHyperPars(learner, ..., par.vals = list())
}
\arguments{
\item{learner}{(\link{Learner} | \code{character(1)})\cr
The learner.
If you pass a string the learner will be created via \link{makeLearner}.}

\item{...}{(any)\cr
Named (hyper)parameters with new setting. Alternatively these can be passed
using the \code{par.vals} argument.}

\item{par.vals}{(\link{list})\cr
Optional list of named (hyper)parameter settings. The arguments in
\code{...} take precedence over values in this list.}
}
\value{
\link{Learner}.
}
\description{
Set the hyperparameters of a learner object.
}
\note{
If a named (hyper)parameter can't be found for the given learner, the 3
closest (hyper)parameter names will be output in case the user mistyped.
}
\examples{
cl1 = makeLearner("classif.ksvm", sigma = 1)
cl2 = setHyperPars(cl1, sigma = 10, par.vals = list(C = 2))
print(cl1)
# note the now set and altered hyperparameters:
print(cl2)
}
\seealso{
Other learner: \code{\link{LearnerProperties}},
  \code{\link{getClassWeightParam}},
  \code{\link{getHyperPars}}, \code{\link{getLearnerId}},
  \code{\link{getLearnerPackages}},
  \code{\link{getLearnerParVals}},
  \code{\link{getLearnerParamSet}},
  \code{\link{getLearnerPredictType}},
  \code{\link{getLearnerShortName}},
  \code{\link{getLearnerType}}, \code{\link{getParamSet}},
  \code{\link{helpLearnerParam}},
  \code{\link{helpLearner}}, \code{\link{makeLearners}},
  \code{\link{makeLearner}}, \code{\link{removeHyperPars}},
  \code{\link{setId}}, \code{\link{setLearnerId}},
  \code{\link{setPredictThreshold}},
  \code{\link{setPredictType}}
}
\concept{learner}
