/**
 * @file src/perceptron.cpp
 *
 * This is an autogenerated file containing implementations of C++ functions to
 * be called by the R perceptron binding.
 */
#include <rcpp_mlpack.h>
#define BINDING_TYPE BINDING_TYPE_R
#include <mlpack/methods/perceptron/perceptron_main.cpp>

// [[Rcpp::export]]
void perceptron_mlpackMain()
{
  mlpackMain();
}

// Any implementations of methods for dealing with model pointers will be put
// below this comment, if needed.

// Get the pointer to a PerceptronModel parameter.
// [[Rcpp::export]]
SEXP IO_GetParamPerceptronModelPtr(const std::string& paramName)
{
  return std::move((Rcpp::XPtr<PerceptronModel>) IO::GetParam<PerceptronModel*>(paramName));
}

// Set the pointer to a PerceptronModel parameter.
// [[Rcpp::export]]
void IO_SetParamPerceptronModelPtr(const std::string& paramName, SEXP ptr)
{
  IO::GetParam<PerceptronModel*>(paramName) =  Rcpp::as<Rcpp::XPtr<PerceptronModel>>(ptr);
  IO::SetPassed(paramName);
}

// Serialize a PerceptronModel pointer.
// [[Rcpp::export]]
Rcpp::RawVector SerializePerceptronModelPtr(SEXP ptr)
{
  std::ostringstream oss;
  {
    boost::archive::binary_oarchive oa(oss);
    oa << boost::serialization::make_nvp("PerceptronModel",
          *Rcpp::as<Rcpp::XPtr<PerceptronModel>>(ptr));
  }

  Rcpp::RawVector raw_vec(oss.str().size());

  // Copy the string buffer so we can return one that won't get deallocated when
  // we exit this function.
  memcpy(&raw_vec[0], oss.str().c_str(), oss.str().size());
  raw_vec.attr("type") = "PerceptronModel";
  return raw_vec;
}

// Deserialize a PerceptronModel pointer.
// [[Rcpp::export]]
SEXP DeserializePerceptronModelPtr(Rcpp::RawVector str)
{
  PerceptronModel* ptr = new PerceptronModel();

  std::istringstream iss(std::string((char *) &str[0], str.size()));
  {
    boost::archive::binary_iarchive ia(iss);
    ia >> boost::serialization::make_nvp("PerceptronModel", *ptr);
  }

  // R will be responsible for freeing this.
  return std::move((Rcpp::XPtr<PerceptronModel>)ptr);
}


