% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_profile.R
\name{get_profile}
\alias{get_profile}
\title{Retrieve Profile Data}
\usage{
get_profile(
  site_nm = NULL,
  stime_dt = NULL,
  poi = NULL,
  time_dt = NULL,
  pcode = NULL,
  strings_as_factors = TRUE
)
}
\arguments{
\item{site_nm}{'character' vector.
Local site name for a MLMS well.}

\item{stime_dt}{'POSIXct' or 'character' vector.
Start time for field visit.}

\item{poi}{'POSIXct' or 'character' vector of length 2.
Start and end limits on the period of interest.}

\item{time_dt}{'POSIXct' or 'character' string.
Estimated field visit time, the closest time in the vector of field visit start times.}

\item{pcode}{'character' string.
USGS 5-digit parameter code. For example, the parameter code for Tritium is "07000".}

\item{strings_as_factors}{'logical' flag.
Whether character vectors should be converted to factor class.}
}
\value{
A data frame.
}
\description{
Retrieve pressure, temperature, and water-quality data for site visits.
}
\examples{
d <- get_profile(site_nm = "USGS 133", pcode = "07000")
str(d)

d <- get_profile(poi = c("2023-01-01", NA), strings_as_factors = FALSE)
str(d)
}
\seealso{
\code{\link{plot_profile}} function to plot multilevel data for a site visit.
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
