% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\name{to_formula}
\alias{to_formula}
\title{Convert \code{\link{mp_data}} to a \code{\link[stats:formula]{stats::formula}} to be used for \code{\link[lme4:lmer]{lme4::lmer}}}
\usage{
to_formula(data, nested = FALSE)
}
\arguments{
\item{data}{the \code{\link{mp_data}} to be coerced.}

\item{nested}{logical value, if true then produce the nested restricted model}
}
\value{
a \code{\link[stats:formula]{stats::formula}}
}
\description{
Produces the formula including the centering functions based on a data set generated with \code{\link{generate}}.
}
\examples{
# Specify model
model <- (
    outcome('Y')
    + within_predictor('X')
    + effect_size(
        icc = 0.2,
        within = 0.3
    )
)
# Set seed
set.seed(198723)
# Create formula based on data set
model |> generate(5, 50) |> to_formula()
}
