% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlnet.R, R/plot.mlnet.R
\name{mlnet}
\alias{mlnet}
\alias{plot.mlnet}
\title{Multilevel Network}
\usage{
mlnet(network, node_memb, directed = FALSE)

\method{plot}{mlnet}(x, node_size = 2.5, palette = NULL,
  memb_colors = NULL, arrow.gap = 0.015, arrow.size = 4,
  color_legend_title = "", legend = TRUE, legend.position = "right",
  layout_type = "kamadakawai", ...)
}
\arguments{
\item{network}{Either a \code{\link{network}} object, an adjacency matrix, or an edge list.}

\item{node_memb}{Vector (length equal to the number of nodes in the network) indicating to which block or group the nodes belong.}

\item{directed}{(\code{TRUE} or \code{FALSE}) Indicates whether the supplied network is directed or undirected. Default is \code{FALSE}.}

\item{x}{An object of class \code{mlnet}, possibly produced by \code{\link{mlnet}} or \code{\link{simulate_mlnet}}.}

\item{node_size}{Controls the size of nodes.}

\item{palette}{If package \code{RColorBrewer} is installed, then the name of an R color brewer pallete can be specified and used for the block colors. See \code{brewer.pal} for details on RColorBrewer palletes.}

\item{memb_colors}{Specifies the named colors to be used for the membership colors.}

\item{arrow.gap}{(Directed graphs only) Controls the amount of space between arrowheads and the nodes.}

\item{arrow.size}{(Directed graphs only) Controls the size of the arrowhead.}

\item{color_legend_title}{Name for the node color legend title.}

\item{legend}{(\code{TRUE} or \code{FALSE}) Controls whether the block membership legend is printed.}

\item{legend.position}{The position of the legend in the plot. Defaults to the "right" position.}

\item{layout_type}{Viable layout options. See \code{gplot.layout} for options.}

\item{\dots}{Additional arguments to be passed to \code{\link{ggnet2}}.}
}
\value{
\code{mlnet} returns an object of class \code{mlnet} which inherits the \code{\link{network}} class, with the additional vector attribute \code{node_memb}, which encodes the block membership of the multilevel netwrok.
}
\description{
Function creates a multilevel network object of class \code{mlnet}. The object inherits the \code{\link{network}} class, with additional information concerning the multilevel structure.
}
\details{
The \code{mlnet} function creates an object of class \code{mlnet} which is used to access methods designed specifically for multilevel networks, including visualization methods as well as direct interface with some of the main functions, such as \code{\link{mlergm}}. Presently, the \code{mlnet} function and object class cover multilevel structure where the set of nodes is nested within known block structure.
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot}: Plots network objects of type \code{mlnet}.
}}

\examples{
 # Show how the sampson dataset can be turned into an mlnet object 
 data(sampson)
 net <- mlnet(samplike, get.vertex.attribute(samplike, "group"))
}
