% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_spreadsheet.R
\name{read_spreadsheet}
\alias{read_spreadsheet}
\title{Read datasets and relevant meta information from a spreadsheet file}
\usage{
read_spreadsheet(
  path,
  valid_datasets = "all",
  parent_only = FALSE,
  normalize = TRUE
)
}
\arguments{
\item{path}{Absolute or relative path to the spreadsheet file}

\item{valid_datasets}{Optional numeric index of the valid datasets, default is
to use all datasets}

\item{parent_only}{Should only the parent data be used?}

\item{normalize}{Should the time scale be normalized using temperature
and moisture normalisation factors in the sheet 'Datasets'?}
}
\description{
This function imports one dataset from each sheet of a spreadsheet file.
These sheets are selected based on the contents of a sheet 'Datasets', with
a column called 'Dataset Number', containing numbers identifying the dataset
sheets to be read in. In the second column there must be a grouping
variable, which will often be named 'Soil'. Optionally, time normalization
factors can be given in columns named 'Temperature' and 'Moisture'.
}
\details{
There must be a sheet 'Compounds', with columns 'Name' and 'Acronym'.
The first row read after the header read in from this sheet is assumed
to contain name and acronym of the parent compound.

The dataset sheets should be named using the dataset numbers read in from
the 'Datasets' sheet, i.e. '1', '2', ... . In each dataset sheet, name
of the observed variable (e.g. the acronym of the parent compound or
one of its transformation products) should be in the first column,
the time values should be in the second colum, and the observed value
in the third column.

In case relevant covariate data are available, they should be given
in a sheet 'Covariates', containing one line for each value of the grouping
variable specified in 'Datasets'. These values should be in the first
column and the column must have the same name as the second column in
'Datasets'. Covariates will be read in from columns four and higher.
Their names should preferably not contain special characters like spaces,
so they can be easily used for specifying covariate models.

An similar data structure is defined as the R6 class \link{mkindsg}, but
is probably more complicated to use.
}
