% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/species_params.R
\name{set_species_param_default}
\alias{set_species_param_default}
\title{Set a species parameter to a default value}
\usage{
set_species_param_default(object, parname, default, message = NULL)
}
\arguments{
\item{object}{Either a MizerParams object or a species parameter data frame}

\item{parname}{A string with the name of the species parameter to set}

\item{default}{A single default value or a vector with one default value for
each species}

\item{message}{A string with a message to be issued when the parameter did
not already exist}
}
\value{
The \code{object} with an updated column in the species params data frame.
}
\description{
If the species parameter does not yet exist in the species parameter data
frame, then create it and fill it with the default. Otherwise use the default
only to fill in any NAs. Optionally gives a message if the parameter
did not already exist.
}
\concept{helper}
