% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\name{mizerPredMort}
\alias{mizerPredMort}
\title{Get total predation mortality rate needed to project standard mizer model}
\usage{
mizerPredMort(params, n, n_pp, n_other, t, pred_rate, ...)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{t}{The time for which to do the calculation (Not used by standard
mizer rate functions but useful for extensions with time-dependent
parameters.)}

\item{pred_rate}{A two dimensional array (predator species x predator size)
with the feeding level.}

\item{...}{Unused}
}
\value{
A two dimensional array (prey species x prey size) with the predation
mortality
}
\description{
Calculates the total predation mortality rate \eqn{\mu_{p,i}(w_p)} (in units
of 1/year) on each prey species by prey size:
\deqn{\mu_{p.i}(w_p) = \sum_j {\tt pred\_rate}_j(w_p)\, \theta_{ji}.}{
  \mu_{p.i}(w_p) = \sum_j pred_rate_j(w_p) \theta_{ji}.}
You would not usually call this
function directly but instead use \code{\link[=getPredMort]{getPredMort()}}, which then calls this
function unless an alternative function has been registered, see below.
}
\section{Your own predation mortality function}{

By default \code{\link[=getPredMort]{getPredMort()}} calls \code{\link[=mizerPredMort]{mizerPredMort()}}. However you can
replace this with your own alternative predation mortality function. If
your function is called \code{"myPredMort"} then you register it in a MizerParams
object \code{params} with

\if{html}{\out{<div class="sourceCode">}}\preformatted{params <- setRateFunction(params, "PredMort", "myPredMort")
}\if{html}{\out{</div>}}

Your function will then be called instead of \code{\link[=mizerPredMort]{mizerPredMort()}}, with the
same arguments.
}

\seealso{
Other mizer rate functions: 
\code{\link{mizerEGrowth}()},
\code{\link{mizerEReproAndGrowth}()},
\code{\link{mizerERepro}()},
\code{\link{mizerEncounter}()},
\code{\link{mizerFMortGear}()},
\code{\link{mizerFMort}()},
\code{\link{mizerFeedingLevel}()},
\code{\link{mizerMort}()},
\code{\link{mizerPredRate}()},
\code{\link{mizerRDI}()},
\code{\link{mizerRates}()},
\code{\link{mizerResourceMort}()}
}
\concept{mizer rate functions}
