% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customFunction.R
\name{customFunction}
\alias{customFunction}
\title{Replace a mizer function with a custom version}
\usage{
customFunction(name, fun)
}
\arguments{
\item{name}{Name of mizer function to replace}

\item{fun}{The custom function to use as replacement}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This function allows you to make arbitrary changes to how mizer works by
allowing you to replace any mizer function with your own version. You
should do this only as a last resort, when you find that you can not use
the standard mizer extension mechanism to achieve your goal.
}
\details{
If the function you need to overwrite is one of the mizer rate functions,
then you should use \code{setRateFunction()} instead of this function. Similarly
you should use \verb{resource_dynamics()<-} to change the resource dynamics and
\code{setReproduction()} to change the density-dependence in reproduction.
You should also investigate whether you can achieve your goal by introducing
additional ecosystem components with \code{setComponent()}.

If you find that your goal really does require you to overwrite a mizer
function, please also create an issue on the mizer issue tracker at
\url{https://github.com/sizespectrum/mizer/issues} to
describe your goal, because it will be interesting to the mizer community
and may motivate future improvements to the mizer functionality.

Note that \code{customFunction()} only overwrites the function used by the mizer
code. It does not overwrite the function that is exported by mizer. This
will become clear when you run the code in the Examples section.

This function does not in any way check that your replacement function is
compatible with mizer. Calling this function can totally break mizer.
However you can always undo the effect by reloading mizer with

\if{html}{\out{<div class="sourceCode">}}\preformatted{detach(package:mizer, unload = TRUE)
library(mizer)
}\if{html}{\out{</div>}}
}
\examples{
\dontrun{
fake_project <- function(...) "Fake"
customFunction("project", fake_project)
mizer::project(NS_params) # This will print "Fake"
project(NS_params) # This will still use the old project() function
# To undo the effect:
customFunction("project", project)
mizer::project(NS_params) # This will again use the old project()
}
}
