% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{NS_species_params}
\alias{NS_species_params}
\title{Example species parameter set based on the North Sea}
\format{
A data frame with 12 rows and 7 columns. Each row is a species.
\describe{
\item{species}{Name of the species}
\item{w_inf}{The von Bertalanffy W_infinity parameter}
\item{w_mat}{Size at maturity}
\item{beta}{Size preference ratio}
\item{sigma}{Width of the size-preference}
\item{R_max}{Maximum reproduction rate}
\item{k_vb}{The von Bertalanffy k parameter}
}
}
\source{
{Blanchard et al.}
}
\description{
This data set is based on species in the North Sea (Blanchard et al.).
It is a data.frame that contains all the necessary information to be used by the
\code{\link[=MizerParams]{MizerParams()}} constructor.
As there is no gear column, each species is assumed to be fished by a
separate gear.
}
\examples{
\dontrun{
params <- MizerParams(NS_species_params)
sim = project(params)
plot(sim)
}
}
