% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_methods.R
\name{getYield}
\alias{getYield}
\title{Calculate the yearly yield for each species}
\usage{
getYield(sim)
}
\arguments{
\item{sim}{An object of class \code{MizerSim}.}
}
\value{
An array (time x species) containing the total yearly yield in
grams.
}
\description{
Calculates the yearly yield (biomass fished per year) for each species
across all gears at each simulation time step.
}
\examples{
\dontrun{
params <- newMultispeciesParams(NS_species_params_gears, inter)
sim <- project(params, effort=1, t_max=10)
y <- getYield(sim)
}
}
\seealso{
\code{\link[=getYieldGear]{getYieldGear()}}

Other summary functions: 
\code{\link{getBiomass}()},
\code{\link{getDiet}()},
\code{\link{getGrowthCurves}()},
\code{\link{getN}()},
\code{\link{getSSB}()},
\code{\link{getYieldGear}()}
}
\concept{summary functions}
\concept{summary_function}
