% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help.R
\docType{package}
\name{mizer}
\alias{mizer}
\alias{mizer-package}
\title{mizer: Multi-species size-based modelling in R}
\description{
The mizer package implements multi-species size-based modelling in R. It has
been designed for modelling marine ecosystems.
}
\details{
Using \pkg{mizer} is relatively simple.  There are three main stages:
\enumerate{

\item Setting the model parameters. This is done by creating an object of
class \linkS4class{MizerParams}. This includes model parameters such as the
life history parameters of each species, and the range of the size spectrum.
There are several setup functions that help to create a MizerParams objects
for particular types of models:
\itemize{
\item \code{\link[=newCommunityParams]{newCommunityParams()}}
\item \code{\link[=newTraitParams]{newTraitParams()}}
\item \code{\link[=newMultispeciesParams]{newMultispeciesParams()}}
}
\item Running a simulation. This is done by calling the
\code{\link[=project]{project()}} function with the model parameters. This produces an
object of \linkS4class{MizerSim} that contains the results of the simulation.

\item Exploring results. After a simulation has been run, the results can be
explored using a range of \code{\link[=plotting_functions]{plotting_functions()}} and
\code{\link[=summary_functions]{summary_functions()}}.
}

See the \href{https://sizespectrum.org/mizer}{mizer website} for full details of
the principles behind mizer and how the package can be used to perform
size-based modelling.
}
