% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\name{mizerFeedingLevel}
\alias{mizerFeedingLevel}
\title{Get feeding level needed to project standard mizer model}
\usage{
mizerFeedingLevel(params, encounter, ...)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{encounter}{A two dimensional array (predator species x predator size)
with the encounter rate.}

\item{...}{Unused}
}
\value{
A two dimensional array (predator species x predator size) with the
feeding level.
}
\description{
Get feeding level needed to project standard mizer model
}
\section{Feeding level}{

The feeding level \eqn{f_i(w)} is the
proportion of its maximum intake rate at which the predator is actually
taking in fish. It is calculated from the encounter rate \eqn{E_i} and the
maximum intake rate \eqn{h_i(w)} as
\deqn{f_i(w) = \frac{E_i(w)}{E_i(w)+h_i(w)}.}{E_i(w)/(E_i(w)+h_i(w)).}
The encounter rate \eqn{E_i} is passed as an argument or calculated with
\code{\link[=getEncounter]{getEncounter()}}. The maximum intake rate \eqn{h_i(w)} is
taken from the \code{params} object, and is set with
\code{\link[=setMaxIntakeRate]{setMaxIntakeRate()}}.
As a consequence of the above expression for the feeding level,
\eqn{1-f_i(w)} is the proportion of the food available to it that the
predator actually consumes.

The feeding level is used in \code{\link[=mizerEReproAndGrowth]{mizerEReproAndGrowth()}} and in
\code{\link[=mizerPredRate]{mizerPredRate()}}.
}

\seealso{
Other mizer rate functions: 
\code{\link{mizerEGrowth}()},
\code{\link{mizerEReproAndGrowth}()},
\code{\link{mizerERepro}()},
\code{\link{mizerEncounter}()},
\code{\link{mizerFMortGear}()},
\code{\link{mizerFMort}()},
\code{\link{mizerMort}()},
\code{\link{mizerPredMort}()},
\code{\link{mizerPredRate}()},
\code{\link{mizerRDI}()},
\code{\link{mizerRates}()},
\code{\link{mizerResourceMort}()}
}
\concept{mizer rate functions}
