% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covlmc_trim.R
\name{trim.covlmc}
\alias{trim.covlmc}
\title{Trim a COVLMC}
\usage{
\method{trim}{covlmc}(ct, keep_model = FALSE, ...)
}
\arguments{
\item{ct}{a context tree.}

\item{keep_model}{specifies whether to keep the internal models (or not)}

\item{...}{additional arguments for the trim function.}
}
\value{
a trimmed context tree.
}
\description{
This function returns a trimmed COVLMC from which cached data have been removed.
}
\details{
Called with \code{keep_model} set to \code{FALSE} (default case), the trimming is maximal and reduces
further usability of the model. In particular \code{\link[=loglikelihood.covlmc]{loglikelihood.covlmc()}} cannot be used
for new data, \code{\link[=contexts.covlmc]{contexts.covlmc()}} do not support model extraction, and
\code{\link[=simulate.covlmc]{simulate.covlmc()}}, \code{\link[=metrics.covlmc]{metrics.covlmc()}}  and \code{\link[=prune.covlmc]{prune.covlmc()}} cannot be used at all.

Called with \code{keep_model} set to \code{TRUE}, the trimming process is less complete. In
particular internal models are simplified using \code{\link[butcher:butcher]{butcher::butcher()}} and some
additional minor reductions. This saves less memory but enables the use of
\code{\link[=loglikelihood.covlmc]{loglikelihood.covlmc()}} for new data as
well as the use of \code{\link[=simulate.covlmc]{simulate.covlmc()}}.
}
\examples{
pc <- powerconsumption[powerconsumption$week \%in\% 5:7, ]
dts <- cut(pc$active_power, breaks = c(0, quantile(pc$active_power, probs = c(0.5, 1))))
dts_cov <- data.frame(day_night = (pc$hour >= 7 & pc$hour <= 17))
m_cov <- covlmc(dts, dts_cov, min_size = 10, keep_data = TRUE)
print(object.size(m_cov), units = "Mb")
t_m_cov_model <- trim(m_cov, keep_model = TRUE)
print(object.size(t_m_cov_model), units = "Mb")
t_m_cov <- trim(m_cov)
print(object.size(t_m_cov), units = "Mb")
}
\seealso{
\code{\link[=tune_covlmc]{tune_covlmc()}}
}
