% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctx_node_covlmc.R
\name{merged_with}
\alias{merged_with}
\title{Merged contexts in a COVLMC}
\usage{
merged_with(node)
}
\arguments{
\item{node}{A \code{ctx_node_covlmc} object as returned by \code{\link[=find_sequence]{find_sequence()}} or
\code{\link[=contexts.covlmc]{contexts.covlmc()}}}
}
\value{
NULL or a list of contexts merged with \code{node} represented by
\code{ctx_node_covlmc} objects
}
\description{
The function returns \code{NULL} when the context represented by the \code{node}
parameter is not merged with another context (see \code{\link[=is_merged]{is_merged()}}). In the
other case, it returns a list of contexts with which this one is merged.
}
\details{
If the context is merged, the function returns a list with one value for each
element in the state space (see \code{\link[=states]{states()}}). The value is \code{NULL} if the
corresponding context is not merged with the \code{node} context, while it is a
\code{ctx_node_covlmc} object in the other case. A context merged with \code{node}
differs from the context represented by \code{node} only in its last value (in
temporal order) which is used as its name in the list. For instance, if the
context \code{ABC} is merged only with \code{CBC} (when represented in temporal
ordering), then the resulting list is of the form \code{list("A" = NULL, "B" = NULL, "C"= ctx_node_covlmc(CBX))}.
}
\examples{
pc_week_15_16 <- powerconsumption[powerconsumption$week \%in\% c(15, 16), ]
elec <- pc_week_15_16$active_power
elec_dts <- cut(elec, breaks = c(0, 0.4, 2, 8), labels = c("low", "typical", "high"))
elec_cov <- data.frame(day = (pc_week_15_16$hour >= 7 & pc_week_15_16$hour <= 18))
elec_tune <- tune_covlmc(elec_dts, elec_cov, min_size = 5)
elec_model <- prune(as_covlmc(elec_tune), alpha = 3.961e-10)
ctxs <- contexts(elec_model)
for (ctx in ctxs) {
  if (is_merged(ctx)) {
    print(ctx)
    cat("\nis merged with\n\n")
    print(merged_with(ctx))
  }
}
}
\seealso{
\code{\link[=is_merged]{is_merged()}}
}
