% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covlmc.R
\name{is_covlmc}
\alias{is_covlmc}
\title{Test if the object is a covlmc model}
\usage{
is_covlmc(x)
}
\arguments{
\item{x}{an R object.}
}
\value{
\code{TRUE} for VLMC models with covariates.
}
\description{
This function returns \code{TRUE} for VLMC models with covariates and \code{FALSE} for other objects.
}
\examples{
pc <- powerconsumption[powerconsumption$week == 5, ]
dts <- cut(pc$active_power, breaks = c(0, quantile(pc$active_power, probs = c(0.5, 1))))
dts_cov <- data.frame(day_night = (pc$hour >= 7 & pc$hour <= 17))
m_cov <- covlmc(dts, dts_cov, min_size = 5)
# should be true
is_ctx_tree(m_cov)
# should be true
is_covlmc(m_cov)
# should be false
is_vlmc(m_cov)
}
