% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_1var.R
\name{plot_bar}
\alias{plot_bar}
\title{Bar plots for multiply imputed values for a single factor variable}
\usage{
plot_bar(
  imputation.list,
  var.name,
  original.data,
  true.data = NULL,
  color.pal = NULL
)
}
\arguments{
\item{imputation.list}{A list of \code{m} imputed datasets returned by the \code{mixgb} imputer}

\item{var.name}{The name of a factor variable of interest}

\item{original.data}{The original data with missing data}

\item{true.data}{The true data without missing values. In general, this is unknown. Only use for simulation studies.}

\item{color.pal}{A vector of hex color codes for the observed and m sets of imputed values panels. The vector should be of length \code{m+1}. Default: NULL (use "gray40" for the observed panel, use ggplot2 default colors for other panels.)}
}
\value{
Bar plots for a factor variable
}
\description{
Plot bar plots of observed values versus m sets of imputed values for a specified factor variable using \pkg{ggplot2}.
}
\examples{
#create some extra missing values in a factor variable "HSSEX" (originally fully observed)
nhanes3_NA<-createNA(nhanes3,var.names="HSSEX",p=0.1)

#obtain m multiply datasets
imputed.data <- mixgb(data = nhanes3_NA, m = 3)

#plot the multiply imputed values for variable "HSSEX"
plot_bar(imputation.list = imputed.data, var.name = "HSSEX",
  original.data = nhanes3_NA)
}
