% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mixedMemModel.R
\name{plot.mixedMemModel}
\alias{plot.mixedMemModel}
\title{Plot a Mixed Membership Model}
\usage{
\method{plot}{mixedMemModel}(x, type = "theta", compare = NULL,
  main = NULL, varNames = NULL, groupNames = NULL, nrow = NULL,
  ncol = NULL, indices = NULL, fitNames = NULL, ...)
}
\arguments{
\item{x}{the \code{mixedMemModel} object to be plotted.}

\item{type}{a string which indicates which estimated parameters to plot; valid options are "theta" or "membership".
\code{vizTheta} is called when the type is "theta" and \code{vizMem} is called when the type is "membership".}

\item{compare}{an array or matrix for comparison. When type = "theta", \code{compare} should be an array the same size as x$theta.
When type = "membership", \code{compare} should be a matrix the same size as x$phi.}

\item{main}{the main figure title.}

\item{varNames}{a vector of strings corresponding to names for each variable if plot type is theta.}

\item{groupNames}{a vector of strings corresponding to labels for each sub-population.}

\item{nrow}{the number of rows for the grid of plots.}

\item{ncol}{the number of columns for the grid of plots. If plot type is "theta", this
must be K, if plot type is  "membership", this must be a positive integer.}

\item{indices}{a vector of integers. If the plot type is  "membership", this indicates which individuals to plot.
When plot type is  "theta", this indicates which variables to plot.}

\item{fitNames}{a vector of strings corresponding to labels for each fit.}

\item{...}{additional parameters to be passed.}
}
\description{
Generic S3 function to produce visual representation of a \code{mixedMemModel} object. This function calls either the \code{vizTheta} or
the \code{vizMem} function.
}
\seealso{
mixedMemModel, vizTheta, vizMem
}

