% Generated by roxygen2 (4.0.2): do not edit by hand
\name{vizMem}
\alias{vizMem}
\title{Mixed Membership Visualization}
\usage{
vizMem(model, compare = NULL, main = "Estimated Membership", nrow = NULL,
  ncol = NULL, indices = NULL, groupNames = NULL, fitNames = NULL)
}
\arguments{
\item{model}{the \code{mixedMemModel} object that will be plotted}

\item{compare}{estimates to compare against. This should be a matrix with same dimensions as model$phi}

\item{main}{title of plot}

\item{nrow}{the number of rows in each plot}

\item{ncol}{the number of columns in each plot}

\item{indices}{the specific individuals to plot. If the argument is left blank, all individuals will be plotted}

\item{groupNames}{vector specifying labels for each sub-population}

\item{fitNames}{the names of the models plotted}
}
\description{
Plots estimates for individual group membership. The estimates used are the
normalized phi, which are the posterior means from the variational distribution. The estimated model is shown in black,
and the comparison (if available) is shown in red.
}
\details{
This is the function called by the plot generic function for mixedMemModel objects
}

