\name{Koren.16S}
\encoding{latin1}
\alias{Koren.16S}

\docType{data}

\title{16S microbiome atherosclerosis study}

\description{
The 16S data come from Koren et al. (2011) and compared the bodysites oral, gut and plaque microbial communities in patients with atherosclerosis. The data can be analysed with our mixMC module. The data include 43 samples measured on 980 OTUs.
}



\usage{data(Koren.16S)}

\format{
A list containing two data sets, \code{data.TSS} and \code{data.raw} and some meta data information:
  \describe{
    \item{\code{data.TSS}}{data frame with 43 rows (samples) and 980 columns (OTUs). The prefiltered normalised data using Total Sum Scaling normalisation.}
    \item{\code{data.raw}}{data frame with 43 rows (samples) and 980 columns (OTUs). The prefiltered raw count OTU data which include a 1 offset (i.e. no 0 values).}
    \item{\code{taxonomy}}{data frame with 980 rows (OTUs) and 7 columns indicating the taxonomy of each OTU.}
    \item{\code{indiv}}{data frame with 43 rows indicating sample meta data.}
    \item{\code{bodysite}}{factor of length 43 indicating the bodysite with levels arterial plaque, saliva and stool.}
}
}

\details{
The data are from Koren et al. (2011) who examined the link between oral, gut and plaque microbial communities in patients with atherosclerosis and controls. Only healthy individuals were retained in the analysis. This study contained partially repeated measures from multiple sites including 15 unique patients samples from saliva and stool, and 13 unique patients only sampled from arterial plaque samples and we therefore considered a non multilevel analysis for that experimental design. After prefiltering, the data included 973 OTU for 43 samples. We strongly recommend to use log ratio transformations on the \code{data.TSS} normalisd data, as implemented in the PLS and PCA methods, see details on  \url{ www.mixOmics.org/mixMC}.

The \code{data.raw} include a 1 offset in order to be log ratios transformed after TSS normalisation. Consequently, the \code{data.TSS} are TSS normalisation of \code{data.raw}.
The CSS normalisation was performed on the orignal data (including zero values)

}

\source{
The raw data were downloaded from the QIITA database.
Filtering and normalisation described in our website \url{ www.mixOmics.org/mixMC}}


\references{
K-A. L\^{e} Cao, ME Costello,  VA Lakis, F Bartolo, XY Chua, R Brazeilles, P Rondeau. MixMC: Multivariate insights into Microbial Communities. PLoS ONE, 11(8): e0160169 (2016).

Koren, O., Spor, A., Felin, J., Fak, F., Stombaugh, J., Tremaroli, V., et al.: Human oral, gut, and plaque microbiota in patients with atherosclerosis. Proceedings of the National Academy of Sciences 108(Supplement 1), 4592-4598 (2011)
}

\keyword{datasets}

