% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chr.color .R
\name{chr.color}
\alias{chr.color}
\title{Colored and Styled Terminal Output Text}
\usage{
chr.color(x, color = c("black", "red", "green", "yellow", "blue", "violet",
                       "cyan", "white", "gray", "b.red", "b.green", "b.yellow",
                       "b.blue", "b.violet", "b.cyan", "b.white"),
          bg = c("none", "black", "red", "green", "yellow", "blue", "violet",
                 "cyan", "white"),
          style = c("regular", "bold", "italic", "underline"), check = TRUE)
}
\arguments{
\item{x}{a character vector.}

\item{color}{a character string indicating the text color, e.g., \code{red}
for red and \code{b.red} for bright red text.}

\item{bg}{a character string indicating the background color of the text,
e.g., \code{red} for red background.}

\item{style}{a character vector indicating the font style, i.e., \code{regular},
(default) for regular text, \code{bold} for bold text, \code{italic},
for italic text, and \code{underline} for underline text. Note
that font styles can be combined, e.g., \code{style = c("bold", "italic")}
provides a bold and italic text.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}
}
\value{
Returns a character vector.
}
\description{
This function adds color and style to output texts on terminals that support
'ANSI' color and highlight codes that can be printed by using the \code{cat}
function.
}
\note{
This function is based on functions provided in the \pkg{crayon} package
by Gábor Csárdi.
}
\examples{
\dontrun{

# Example 1:
cat(chr.color("Text in red.", color = "red"))

# Example 2:
cat(chr.color("Text in blue with green background.",
              color = "blue", bg = "yellow"))

# Example 3a:
cat(chr.color("Text in boldface.", style = "bold"))

# Example 3b:
cat(chr.color("Text in boldface and italic.", style = c("bold", "italic")))

}
}
\references{
Csárdi G (2022). \emph{crayon: Colored Terminal Output}. R package version 1.5.2,
https://CRAN.R-project.org/package=crayon
}
\author{
Takuya Yanagida
}
