% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standist.R
\name{q.default}
\alias{q.default}
\title{Terminate an R Session}
\usage{
\method{q}{default}(
  O = save,
  p = status,
  lower.tail = runLast,
  log.p = FALSE,
  save = "default",
  status = 0,
  runLast = TRUE,
  ...
)
}
\arguments{
\item{O}{place holder for generic, by default set to save, default: save.}

\item{p}{place holder for generic, by default set to status, default: status.}

\item{lower.tail}{place holder for generic, by default set to runLast, default: runLast.}

\item{log.p}{place holder for generic, default: FALSE.}

\item{save}{a character string indicating whether the environment (workspace) should be saved, one of "no", "yes", "ask" or "default", default: 'default'.}

\item{status}{the (numerical) error status to be returned to the operating system, where relevant. Conventionally 0 indicates successful completion, default: 0.}

\item{runLast}{should .Last() be executed?, default: TRUE.}

\item{...}{further arguments to be passed.}
}
\description{
The default method \code{q.default} terminates the current R session.
}
\details{
This method is designed to quit R if the \code{q()} without a distribution is called.
         The reason for such an implementation is R-Studio in Linux and Mac systems, where
         the software calls \code{q()} (rather than \code{base::q()}) once the R-Studio window
         is closed. Such implementation solves the issued with the overwriting of \code{q()}.
}
\seealso{
\code{\link[base]{q}}
}
