% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_risk.R
\name{PNP_fit}
\alias{PNP_fit}
\title{Fitting a Pareto-Normal-Pareto Model}
\usage{
PNP_fit(
  data,
  start = c(break1 = -0.02, break2 = 0.02, mean = 0, sd = 0.012),
  ...
)
}
\arguments{
\item{data}{vector of values to which the density is optimized.}

\item{start}{named vector (break1, break2, mean, sd) of values that are used to start the optimization,
default: c(break1 = -0.02, break2 = 0.02, mean = 0, sd = 0.012).}

\item{...}{further arguments to be passed to optimizer.}
}
\value{
A list of class comp_fit.
}
\description{
\code{GNG_fit} is used to fit three components composite models with components Pareto, normal and Pareto.
}
\details{
The PNP model is the Pareto-Normal-Pareto model. This means
         that a \eqn{-X} transformation of a Pareto random variable will be used for the left tail,
         normal distribution for the center and again Pareto for the right tail.

         The code uses the maximum likelihood estimation technique to estimate the four parameters from the start vector
         (\code{break1, break2, mean, sd}). The other parameters (shape parameters of Pareto distribution) are
         computed in each step such that the function is continuous. Weights are estimated in every step as a proportion
         of points that correspond to each of the truncated region.

         Optimization is handled by the \code{\link[bbmle]{mle2}} function.
}
\examples{
\dontrun{
 PNP_fit(stocks$SAP)

 PNP_fit(stocks$MSFT)

 autoplot(PNP_fit(stocks$ADS))

 PNP_fit(stocks$GSPC, method = "BFGS")

 PNP_fit(stocks$DJI, start = c(-0.01,0.01,0,0.008))

}
}
\seealso{
\code{\link[bbmle]{mle2}}
}
