% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpqr_new.R
\name{Gumbel}
\alias{Gumbel}
\alias{dgumbel}
\alias{pgumbel}
\alias{qgumbel}
\alias{rgumbel}
\title{The Gumbel Distribution}
\usage{
dgumbel(x, loc, scale, log = FALSE)

pgumbel(q, loc, scale, lower.tail = TRUE, log.p = FALSE)

qgumbel(p, loc, scale, lower.tail = TRUE, log.p = FALSE)

rgumbel(n, loc, scale)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{loc}{location parameter.}

\item{scale}{scale parameter.}

\item{log, log.p}{logical; if TRUE, probabilities \eqn{p} are given as \eqn{log(p)}, default: FALSE.}

\item{lower.tail}{logical; if TRUE, probabilities are \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}, default: TRUE.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dgumbel} gives the density, \code{pgumbel} gives the distribution function, \code{qgumbel} gives the quantile function, and
        \code{rgumbel} generates random deviates.

        Invalid arguments will result in return value NaN, with a warning.
}
\description{
Density, distribution function, quantile function and random generation for the Gumbel distribution with
location and scale parameters.
}
\details{
The Gumbel distribution function with location parameter \eqn{\mu} and scale parameter \eqn{\beta} has density given by
         \deqn{f(x)=1/\beta e^-(z+e^-z)}, where \eqn{z=(x-\mu)/\beta}. The cumulative distribution function is
         \deqn{F(x)=e^(-e^z)} with \eqn{z} as stated above.

         See \url{https://en.wikipedia.org/wiki/Gumbel_distribution} for more details.
}
\examples{
dgumbel(seq(1, 5), 0, 1)
qgumbel(pgumbel(seq(1, 5), 0, 1), 0 ,1)
rgumbel(5, 0, 1)
}
\seealso{
\code{\link{gumbeldist}}
}
