% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpqr_new.R
\name{Frechet}
\alias{Frechet}
\alias{dfrechet}
\alias{pfrechet}
\alias{qfrechet}
\alias{rfrechet}
\title{The Frechet Distribution}
\usage{
dfrechet(x, loc = 0, scale = 1, shape = 1, log = FALSE)

pfrechet(q, loc = 0, scale = 1, shape = 1, lower.tail = TRUE,
  log.p = FALSE)

qfrechet(p, loc = 0, scale = 1, shape = 1, lower.tail = TRUE,
  log.p = FALSE)

rfrechet(n, loc = 0, scale = 1, shape = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{loc}{location parameter.}

\item{scale}{scale parameter.}

\item{shape}{shape parameter.}

\item{log, log.p}{logical; if TRUE, probabilities \eqn{p} are given as \eqn{log(p)}, default: FALSE.}

\item{lower.tail}{logical; if TRUE, probabilities are \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}, default: TRUE.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dfrechet} gives the density, \code{pfrechet} gives the distribution function, \code{qfrechet} gives the quantile function, and
        \code{rfrechet} generates random deviates.

        Invalid arguments will result in return value NaN, with a warning.
}
\description{
Density, distribution function, quantile function and random generation for the Frechet distribution with
location, scale and shape parameters.
}
\details{
The Frechet distribution function with location parameter \eqn{m}, scale parameter \eqn{s} and shape parameter
         \eqn{\alpha} has density given by
         \deqn{f(x)=\alpha/s z^(-\alpha-1) e^-z^-\alpha} for \eqn{x>m}, where \eqn{z=(x-m)/s}. The cumulative distribution function is
         \deqn{F(x)=e^-z^-\alpha} for \eqn{x>m}, with \eqn{z} as stated above.

         See \url{https://en.wikipedia.org/wiki/Frechet_distribution} for more details.
}
\examples{
dfrechet(seq(1, 5), 0, 1, 1)
qfrechet(pfrechet(seq(1, 5), 0, 1, 1), 0, 1, 1)
rfrechet(5, 0, 1, 1)
}
\seealso{
\code{\link{frechetdist}}
}
