% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_censoring.R
\name{delete_MNAR_censoring}
\alias{delete_MNAR_censoring}
\title{Create MNAR values using a censoring mechanism}
\usage{
delete_MNAR_censoring(
  ds,
  p,
  cols_mis,
  n_mis_stochastic = FALSE,
  where = "lower",
  sorting = TRUE,
  miss_cols
)
}
\arguments{
\item{ds}{A data frame or matrix in which missing values will be created.}

\item{p}{A numeric vector with length one or equal to length \code{cols_mis};
the probability that a value is missing.}

\item{cols_mis}{A vector of column names or indices of columns in which
missing values will be created.}

\item{n_mis_stochastic}{Logical, should the number of missing values be
stochastic? If \code{n_mis_stochastic = TRUE}, the number of missing values
for a column with missing values \code{cols_mis[i]} is a random variable
with expected value \code{nrow(ds) * p[i]}. If \code{n_mis_stochastic =
FALSE}, the number of missing values will be deterministic. Normally, the
number of missing values for a column with missing values
\code{cols_mis[i]} is \code{round(nrow(ds) * p[i])}. Possible deviations
from this value, if any exists, are documented in Details.}

\item{where}{Controls where missing values are created; one of "lower",
"upper" or "both" (see details).}

\item{sorting}{Logical; should sorting be used or a quantile as a threshold.}

\item{miss_cols}{Deprecated, use \code{cols_mis} instead.}
}
\value{
An object of the same class as \code{ds} with missing values.
}
\description{
Create missing not at random (MNAR) values using a censoring mechanism in a
data frame or a matrix
}
\details{
The functions \code{delete_MNAR_censoring} and \code{\link{delete_MAR_censoring}} are sisters. The only difference between these two functions is the column that controls the generation of missing values. In \code{\link{delete_MAR_censoring}} a separate column \code{cols_ctrl[i]} controls the generation of missing values in \code{cols_mis[i]}. In contrast, in \code{delete_MNAR_censoring} the generation of missing values in \code{cols_mis[i]} is controlled by \code{cols_mis[i]} itself. All other aspects are identical for both functions. Therefore, further details can be found in \code{\link{delete_MAR_censoring}}.
}
\examples{
ds <- data.frame(X = 1:20, Y = 101:120)
delete_MNAR_censoring(ds, 0.2, "X")
}
\references{
Santos, M. S., Pereira, R. C., Costa, A. F., Soares, J. P.,
  Santos, J., & Abreu, P. H. (2019). Generating Synthetic Missing Data: A
  Review by Missing Mechanism. \emph{IEEE Access}, 7, 11651-11667
}
\seealso{
\code{\link{delete_MAR_censoring}}

Other functions to create MNAR: 
\code{\link{delete_MNAR_1_to_x}()},
\code{\link{delete_MNAR_one_group}()},
\code{\link{delete_MNAR_rank}()}
}
\concept{functions to create MNAR}
