% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_parameters.R
\name{evaluate_parameters}
\alias{evaluate_parameters}
\title{Evaluate estimated parameters}
\usage{
evaluate_parameters(
  pars_est,
  pars_true,
  criterion = "RMSE",
  tolerance = sqrt(.Machine$double.eps),
  est_pars,
  true_pars
)
}
\arguments{
\item{pars_est}{A vector or matrix of estimated parameters.}

\item{pars_true}{True parameters, normally a vector or a matrix.}

\item{criterion}{A string specifying the used criterion for comparing the
imputed and original values.}

\item{tolerance}{Numeric, only used for \code{criterion = "precision"}:
numeric differences smaller than tolerance are treated as zero/equal.}

\item{est_pars}{Deprecated, renamed to \code{pars_est}.}

\item{true_pars}{Deprecated, renamed to \code{pars_true}.}
}
\value{
A numeric vector of length one.
}
\description{
Compare estimated parameters to true parameters
}
\details{
The same \code{criterion}s are implemented for
\code{evaluate_parameters} and \code{\link{evaluate_imputed_values}}.
The possible choices are documented in \code{\link{evaluate_imputed_values}}.
}
\examples{
evaluate_parameters(1:4, 2:5, "RMSE")
}
\references{
Cetin-Berber, D. D., Sari, H. I., & Huggins-Manley, A. C. (2019).
  Imputation Methods to Deal With Missing Responses in Computerized Adaptive
  Multistage Testing. \emph{Educational and psychological measurement},
  79(3), 495-511.
}
\seealso{
Other evaluation functions: 
\code{\link{evaluate_imputation_parameters}()},
\code{\link{evaluate_imputed_values}()}
}
\concept{evaluation functions}
