% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.R
\name{gsample}
\alias{gsample}
\title{Returns samples from the values of track expression}
\usage{
gsample(expr = NULL, n = NULL, intervals = NULL, iterator = NULL, band = NULL)
}
\arguments{
\item{expr}{track expression}

\item{n}{a number of items to choose}

\item{intervals}{genomic scope for which the function is applied}

\item{iterator}{track expression iterator. If 'NULL' iterator is determined
implicitly based on track expression.}

\item{band}{track expression band. If 'NULL' no band is used.}
}
\value{
An array that represent quantiles.
}
\description{
Returns a sample of the specified size from the values of track expression.
}
\details{
This function returns a sample of the specified size from the values of
track expression. If 'n' is less than the total number of values, the data
is randomly sampled. The seed of the pseudo-random generator can be
controlled through 'grnd.seed' option.

If 'n' is higher than the total number of values, all values are returned
(yet reshuffled).
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
gsample("sparse_track", 10)

}
\seealso{
\code{\link{gextract}}
}
\keyword{~sample}
