% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ggplotlist}
\alias{ggplotlist}
\title{Arrange a List of ggplots}
\usage{
ggplotlist(x, ncol = 1, path, width = 11, height = 8)
}
\arguments{
\item{x}{A list containing at least one ggplot object of class \code{gg}.}

\item{ncol}{Number of columns in the grid.}

\item{path}{Optional. A character string that gives the path to export
the plot to a file, ending with 'pdf' or 'png' (case insensitive). If
missing, then the grid is returned to the current graphic device.}

\item{height,width}{A numeric value in inches for the size of the output
file in case \code{path} is provided. Else ignored.}
}
\description{
Arrange a list of ggplots with \link[gridExtra]{grid.arrange} and
output on local graphic device or as pdf/png when a path is supplied.
}
\examples{
#

\dontrun{
library(ggplot2)
x <- list(
  ggplot(data.frame(a=1:5,b=1:5), aes(x=a,y=b,col=b)) + geom_line(),
  ggplot(data.frame(a=1:5,b=1:5), aes(x=a,y=b,shape=factor(b))) + geom_point())
ggplotlist(x, 2)}

#
}
\author{
Sven E. Templer \email{sven.templer@gmail.com}
}

