% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai-package.R
\docType{package}
\name{mirai-package}
\alias{mirai-package}
\title{mirai: Minimalist Async Evaluation Framework for R}
\description{
Designed for simplicity, a 'mirai' evaluates an R expression asynchronously,
locally or distributed over the network. Built on 'nanonext' and 'NNG' for
modern networking and concurrency, scales efficiently to millions of tasks
over thousands of persistent parallel processes. Provides optimal scheduling
over fast 'IPC', TCP, and TLS connections, integrating with SSH or cluster
managers. Implements event-driven promises for reactive programming, and
supports custom serialization for cross-language data types.
}
\section{Notes}{


For local mirai requests, the default transport for inter-process
communications is platform-dependent: abstract Unix domain sockets on Linux,
Unix domain sockets on MacOS, Solaris and other POSIX platforms, and named
pipes on Windows.

This may be overriden, if desired, by specifying 'url' in the \code{\link[=daemons]{daemons()}}
interface and launching daemons using \code{\link[=launch_local]{launch_local()}}.
}

\section{OpenTelemetry}{


mirai provides comprehensive OpenTelemetry tracing support for observing
asynchronous operations and distributed computation. Please refer to the
OpenTelemetry vignette for further details:
\code{vignette("v05-opentelemetry", package = "mirai")}
}

\section{Reference Manual}{


\code{vignette("mirai", package = "mirai")}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://mirai.r-lib.org}
  \item \url{https://github.com/r-lib/mirai}
  \item Report bugs at \url{https://github.com/r-lib/mirai/issues}
}

}
\author{
\strong{Maintainer}: Charlie Gao \email{charlie.gao@posit.co} (\href{https://orcid.org/0000-0002-0750-061X}{ORCID})

Other contributors:
\itemize{
  \item Joe Cheng \email{joe@posit.co} [contributor]
  \item Posit Software, PBC (\href{https://ror.org/03wc8by49}{ROR}) [copyright holder, funder]
  \item Hibiki AI Limited [copyright holder]
}

}
