% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daemon.R
\name{daemon}
\alias{daemon}
\title{Daemon Instance}
\usage{
daemon(
  url,
  dispatcher = FALSE,
  ...,
  asyncdial = FALSE,
  autoexit = TRUE,
  cleanup = TRUE,
  output = FALSE,
  idletime = Inf,
  walltime = Inf,
  maxtasks = Inf,
  id = NULL,
  tls = NULL,
  rs = NULL
)
}
\arguments{
\item{url}{the character host or dispatcher URL to dial into, including the
port to connect to, e.g. 'tcp://hostname:5555' or
'tls+tcp://10.75.32.70:5555'.}

\item{dispatcher}{[default FALSE] logical value, which should be set to TRUE
if using dispatcher and FALSE otherwise.}

\item{...}{reserved but not currently used.}

\item{asyncdial}{[default FALSE] whether to perform dials asynchronously. The
default FALSE will error if a connection is not immediately possible (for
instance if \code{\link{daemons}} has yet to be called on the host, or the
specified port is not open etc.). Specifying TRUE continues retrying
(indefinitely) if not immediately successful, which is more resilient but
can mask potential connection issues.}

\item{autoexit}{[default TRUE] logical value, whether the daemon should exit
automatically when its socket connection ends. If a signal from the
\pkg{tools} package, such as \code{tools::SIGINT}, or an equivalent integer
value is supplied, this signal is additionally raised on exit (see
'Persistence' section below).}

\item{cleanup}{[default TRUE] logical value, whether to perform cleanup of
the global environment and restore attached packages and options to an
initial state after each evaluation.}

\item{output}{[default FALSE] logical value, to output generated stdout /
stderr if TRUE, or else discard if FALSE. Specify as TRUE in the
\sQuote{...} argument to \code{\link{daemons}} or
\code{\link{launch_local}} to provide redirection of output to the host
process (applicable only for local daemons).}

\item{idletime}{[default Inf] integer milliseconds maximum time to wait for a
task (idle time) before exiting.}

\item{walltime}{[default Inf] integer milliseconds soft walltime (time limit)
i.e. the minimum amount of real time elapsed before exiting.}

\item{maxtasks}{[default Inf] integer maximum number of tasks to execute
(task limit) before exiting.}

\item{id}{[default NULL] (optional) integer daemon ID provided to dispatcher
to track connection status. Causes \code{\link{status}} to report this ID
under \code{$events} when the daemon connects and disconnects.}

\item{tls}{[default NULL] required for secure TLS connections over
'tls+tcp://'. \strong{Either} the character path to a file containing X.509
certificate(s) in PEM format, comprising the certificate authority
certificate chain starting with the TLS certificate and ending with the CA
certificate, \strong{or} a length 2 character vector comprising [i] the
certificate authority certificate chain and [ii] the empty string \code{''}.}

\item{rs}{[default NULL] the initial value of .Random.seed. This is set
automatically using L'Ecuyer-CMRG RNG streams generated by the host process
and should not be independently supplied.}
}
\value{
Invisibly, an integer exit code: 0L for normal termination, and a
  positive value if a self-imposed limit was reached: 1L (idletime), 2L
  (walltime), 3L (maxtasks).
}
\description{
Starts up an execution daemon to receive \code{\link{mirai}} requests. Awaits
data, evaluates an expression in an environment containing the supplied data,
and returns the value to the host caller. Daemon settings may be controlled
by \code{\link{daemons}} and this function should not need to be invoked
directly, unless deploying manually on remote resources.
}
\details{
The network topology is such that daemons dial into the host or dispatcher,
which listens at the \sQuote{url} address. In this way, network resources may
be added or removed dynamically and the host or dispatcher automatically
distributes tasks to all available daemons.
}
\section{Persistence}{


The \sQuote{autoexit} argument governs persistence settings for the daemon.
The default TRUE ensures that it will exit cleanly once its socket connection
has ended.

Instead of TRUE, supplying a signal from the \pkg{tools} package, such as
\code{tools::SIGINT}, or an equivalent integer value, sets this signal to be
raised when the socket connection ends. For instance, supplying SIGINT allows
a potentially more immediate exit by interrupting any ongoing evaluation
rather than letting it complete.

Setting to FALSE allows the daemon to persist indefinitely even when there is
no longer a socket connection. This allows a host session to end and a new
session to connect at the URL where the daemon is dialled in. Daemons must be
terminated with \code{daemons(NULL)} in this case, which sends explicit exit
signals to all connected daemons.
}

