% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel.R
\name{make_cluster}
\alias{make_cluster}
\alias{stop_cluster}
\title{Make Mirai Cluster}
\usage{
make_cluster(n, url = NULL, remote = NULL, ...)

stop_cluster(cl)
}
\arguments{
\item{n}{integer number of nodes (automatically launched on the local machine
unless \sQuote{url} is supplied).}

\item{url}{[default NULL] (specify for remote nodes) the character URL on the
host for remote nodes to dial into, including a port accepting incoming
connections, e.g. 'tcp://10.75.37.40:5555'. Specify a URL with the scheme
\sQuote{tls+tcp://} to use secure TLS connections.}

\item{remote}{[default NULL] (specify to launch remote nodes) a remote launch
configuration generated by \code{\link{remote_config}} or
\code{\link{ssh_config}}. If not supplied, nodes may be deployed manually
on remote resources.}

\item{...}{additional arguments passed onto \code{\link{daemons}}.}

\item{cl}{a \sQuote{miraiCluster}.}
}
\value{
For \strong{make_cluster}: An object of class \sQuote{miraiCluster}
    and \sQuote{cluster}. Each \sQuote{miraiCluster} has an automatically
    assigned ID and \sQuote{n} nodes of class \sQuote{miraiNode}. If
    \sQuote{url} is supplied but not \sQuote{remote}, the shell commands for
    deployment of nodes on remote resources are printed to the console.

    For \strong{stop_cluster}: invisible NULL.
}
\description{
\code{make_cluster} creates a cluster of type \sQuote{miraiCluster}, which
    may be used as a cluster object for any function in the \pkg{parallel}
    base package such as \code{\link[parallel]{clusterApply}} or
    \code{\link[parallel]{parLapply}}.

\code{stop_cluster} stops a cluster created by \code{make_cluster}.
}
\note{
The default behaviour of clusters created by this function is designed
    to map as closely as possible to clusters created by the \pkg{parallel}
    package. However, \sQuote{...} arguments are passed onto
    \code{\link{daemons}} for additional customisation if desired, although
    resultant behaviour may not always be supported.
}
\section{Remote Nodes}{


    Specify \sQuote{url} and \sQuote{n} to set up a host connection for
    remote nodes to dial into. \sQuote{n} defaults to one if not specified.

    Also specify \sQuote{remote} to launch the nodes using a configuration
    generated by \code{\link{remote_config}} or \code{\link{ssh_config}}.
    In this case, the number of nodes is inferred from the configuration
    provided and \sQuote{n} is disregarded.

    If \sQuote{remote} is not supplied, the shell commands for deploying
    nodes manually on remote resources are automatically printed to the
    console.

    \code{\link{launch_remote}} may be called at any time on a
    \sQuote{miraiCluster} to return the shell commands for deployment of all
    nodes, or on a \sQuote{miraiNode} to return the command for a single node.
}

\section{Status}{


    Call \code{\link{status}} on a \sQuote{miraiCluster} to check the number
    of currently active connections as well as the host URL.
}

\section{Errors}{


    Errors are thrown by the \sQuote{parallel} mechanism if one or more nodes
    failed (quit unexpectedly). The resulting \sQuote{errorValue} returned is
    19 (Connection reset). Other types of error, e.g. in evaluation, should
    result in the usual \sQuote{miraiError} being returned.
}

\examples{
if (interactive()) {
# Only run examples in interactive R sessions

cl <- make_cluster(2)
cl
cl[[1L]]

Sys.sleep(0.5)
status(cl)

stop_cluster(cl)

}

}
