% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{is_mirai_error}
\alias{is_mirai_error}
\alias{is_mirai_interrupt}
\alias{is_error_value}
\title{Error Validators}
\usage{
is_mirai_error(x)

is_mirai_interrupt(x)

is_error_value(x)
}
\arguments{
\item{x}{an object.}
}
\value{
Logical value TRUE or FALSE.
}
\description{
Validator functions for error value types created by \pkg{mirai}.
}
\details{
Is the object a \sQuote{miraiError}. When execution in a
    \sQuote{mirai} process fails, the error message is returned as a
    character string of class \sQuote{miraiError} and \sQuote{errorValue}.
    The stack trace is available at \code{$stack.trace} on the error object.

    Is the object a \sQuote{miraiInterrupt}. When an ongoing \sQuote{mirai}
    is sent a user interrupt, it will resolve to an empty character string
    classed as \sQuote{miraiInterrupt} and \sQuote{errorValue}.

    Is the object an \sQuote{errorValue}, such as a \sQuote{mirai} timeout,
    a \sQuote{miraiError} or a \sQuote{miraiInterrupt}. This is a catch-all
    condition that includes all returned error values.
}
\examples{
if (interactive()) {
# Only run examples in interactive R sessions

m <- mirai(stop())
call_mirai(m)
is_mirai_error(m$data)
is_mirai_interrupt(m$data)
is_error_value(m$data)
m$data$stack.trace

m2 <- mirai(Sys.sleep(1L), .timeout = 100)
call_mirai(m2)
is_mirai_error(m2$data)
is_mirai_interrupt(m2$data)
is_error_value(m2$data)

}

}
