% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{daemons}
\alias{daemons}
\title{daemons (Persistent Server Processes)}
\usage{
daemons(n, .url)
}
\arguments{
\item{n}{integer number of daemons to set | 'view' to view the current number
of daemons.}

\item{.url}{(optional) for distributing tasks across the network: character
client URL and port accepting incoming connections e.g.
'tcp://192.168.0.2:5555' at which server processes started using
\code{\link{server}} should connect to. To listen to port 5555 (for
example) on all interfaces on the host, specify one of 'tcp://:5555',
'tcp://*:5555' or 'tcp://0.0.0.0:5555'.}
}
\value{
Depending on 'n' specified:
    \itemize{
    \item{integer: integer change in number of daemons (created or destroyed).}
    \item{'view': integer number of currently set daemons.}
    }
    Calling \code{daemons()} without any arguments returns the 'nanoSocket'
    for connecting to the daemons, or NULL if it is yet to be created.
}
\description{
Set or view the number of 'daemons' or persistent server processes receiving
    \code{\link{mirai}} requests. These are, by default, automatically
    created on the local machine. Alternatively, a client URL may be set to
    receive connections from remote servers started with \code{\link{server}},
    for distributing tasks across the network.
}
\details{
Set 'n' to 0 to reset all daemon connections. \{mirai\} will revert
    to the default behaviour of creating a new background process for each
    request.

    Specifying '.url' without 'n' assumes a value for 'n' of 1. After setting
    '.url', further calls specifying 'n' can be used to update the number of
    connected daemons (this is not strictly necessary as daemons are detected
    automatically, but will ensure that the correct number of shutdown signals
    are sent when the session is ended).

    Setting a new '.url' value will attempt to shutdown existing daemons
    connected at the existing address before opening a connection at the new
    address.
}
\section{About}{


    Daemons provide a potentially more efficient solution for asynchronous
    operations as new processes no longer need to be created on an ad hoc
    basis.

    Specifying '.url' allows tasks to be distributed across the network. The
    network topology is such that server daemons (started with
    \code{\link{server}}) dial into the client, which listens at the '.url'
    address. In this way, network resources may be added or removed at any
    time. The client automatically distributes tasks to all available servers.

    The current implementation is low-level and ensures tasks are
    evenly-distributed amongst daemons without actively managing a task queue.
    This approach provides a robust and resource-light solution, particularly
    well-suited to working with similar-length tasks, or where the number of
    concurrent tasks typically does not exceed the number of available
    daemons.
}

\examples{
if (interactive()) {
# Only run examples in interactive R sessions

# Create 2 daemons
daemons(2)
# View the number of active daemons
daemons("view")
# Reset to zero
daemons(0)

}

}
