% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getChEBI.R
\name{getChEBI}
\alias{getChEBI}
\title{Download the ChEBI database}
\usage{
getChEBI(release = "latest")
}
\arguments{
\item{release}{A release number of the ChEBI database version to be downloaded, by default \code{'latest'} release is downloaded.}
}
\value{
A data.frame with the following data associated to the ChEBI compounds: \itemize{
\item \code{"ID"}: The unique identifer
\item \code{"ChEBI"}: The name recommended for use in biological databases
\item \code{"KEGG"}: The associated name(s) in the KEGG database
\item \code{"IUPAC"}: The name(s) generated according to recommendations of IUPAC
\item \code{"MetaCyc"}: The associated name(s) in the MetaCyc database
\item \code{"ChEMBL"}: The associated name(s) in the ChEMBL database
\item \code{"FORMULA"}: The molecular formula
\item \code{"MASS"}: The molecular mass
\item \code{"MONOISOTOPIC"}: The molecular monoisotopic mass
\item \code{"CHARGE"}: The molecular net charge 
 }
}
\description{
This function downloads the compounds, formulas, masses and charges from the selected release of the ChEBI database. 
The ChEBI database (Chemical Entities of Biological Interest), is a database and ontology of molecular entities focused on 'small' chemical compounds.
}
\examples{
\dontrun{
ChEBI <- getChEBI(release = "142")
 }
}
\author{
Daniel Camilo Osorio <dcosorioh@unal.edu.co>
}
\seealso{
The ChEBI database webpage: https://www.ebi.ac.uk/chebi/
}
\keyword{ChEBI}
\keyword{Download}
\keyword{balance}
\keyword{charge}
\keyword{check}
\keyword{mass}

