% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/association.test.logistic.dosages.r
\name{association.test.logistic.dosage}
\alias{association.test.logistic.dosage}
\title{Mixed logistic regression for GWAS, using dosages}
\usage{
association.test.logistic.dosage(
  filename,
  Y,
  X,
  K,
  beg,
  end,
  algorithm = c("amle", "offset"),
  eigenK,
  p = 0,
  n.cores = 1L,
  ...
)
}
\arguments{
\item{filename}{Name of a dosage file}

\item{Y}{phenotype vector. Default is column \code{pheno} of \code{x@ped}}

\item{X}{A matrix of covariates (defaults to a column of ones for the intercept)}

\item{K}{A genetic relationship matrix (or a list of such matrices)}

\item{beg}{Index of the first SNP tested for association}

\item{end}{Index of the last SNP tested for association}

\item{algorithm}{Algorithm to use}

\item{eigenK}{eigen decomposition of K (only if \code{p} > 0)}

\item{p}{Number of principal components to include in the model}

\item{n.cores}{Number of cores to use}

\item{...}{Additional parameter for \code{gaston::logistic.mm.aireml}}
}
\value{
A data frame giving for each SNP the association statistics.
}
\description{
Mixed logistic regression for GWAS, using dosages
}
\details{
Dosage files can be VCF files with 'DS' or 'GP' fields. It is also possible to use a file
with columns 'id"', 'chr', 'pos', 'A1', 'A2', 'sample1', 'sample2', etc. These files should have a 
header with column names.

For more details refer to \code{\link{association.test.logistic}} and \code{\link[gaston]{association.test}}.
}
\seealso{
\code{\link{association.test.logistic}}, \code{\link[gaston]{association.test}}
}
