% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_hierarchy.R
\name{hierarchy}
\alias{hierarchy}
\alias{network_connectedness}
\alias{network_efficiency}
\alias{network_upperbound}
\title{Graph theoretic dimensions of hierarchy}
\usage{
network_connectedness(.data)

network_efficiency(.data)

network_upperbound(.data)
}
\arguments{
\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}
}
\description{
These functions, together with \code{network_reciprocity()}, are used jointly to
measure how hierarchical a network is:
\itemize{
\item \code{network_connectedness()} measures the proportion of dyads in the network
that are reachable to one another,
or the degree to which network is a single component.
\item \code{network_efficiency()} measures the Krackhardt efficiency score.
\item \code{network_upperbound()} measures the Krackhardt (least) upper bound score.
}
}
\examples{
network_connectedness(ison_networkers)
1 - network_reciprocity(ison_networkers)
network_efficiency(ison_networkers)
network_upperbound(ison_networkers)
}
\references{
Krackhardt, David. 1994.
Graph theoretical dimensions of informal organizations.
In Carley and Prietula (eds) \emph{Computational Organizational Theory},
Hillsdale, NJ: Lawrence Erlbaum Associates. Pp. 89-111.

Everett, Martin, and David Krackhardt. 2012.
“A second look at Krackhardt's graph theoretical dimensions of informal organizations.”
\emph{Social Networks}, 34: 159-163.
\doi{10.1016/j.socnet.2011.10.006}
}
\seealso{
Other measures: 
\code{\link{between_centrality}},
\code{\link{close_centrality}},
\code{\link{closure}},
\code{\link{cohesion}()},
\code{\link{degree_centrality}},
\code{\link{eigenv_centrality}},
\code{\link{features}},
\code{\link{heterogeneity}},
\code{\link{holes}},
\code{\link{net_diffusion}},
\code{\link{node_diffusion}},
\code{\link{periods}}
}
\concept{measures}
