% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity.R
\name{diversity}
\alias{diversity}
\alias{graph_blau_index}
\alias{graph_ei_index}
\title{Measures of network diversity}
\usage{
graph_blau_index(object, attribute, clusters = NULL)

graph_ei_index(object, attribute)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix, from base R
\item edgelist, a data frame from base R or tibble from tibble
\item igraph, from the igraph package
\item network, from the network package
\item tbl_graph, from the tidygraph package
}}

\item{attribute}{The name of a vertex attribute to measure the diversity of.}

\item{clusters}{A nodal cluster membership vector or name of a vertex attribute.}
}
\description{
These functions offer ways to summarise the heterogeneity of an attribute
across a network, within groups of a network, or the distribution of ties
across this attribute.
}
\examples{
marvel_friends <- to_unsigned(ison_marvel_relationships, "positive")
graph_blau_index(marvel_friends, "Gender")
graph_blau_index(marvel_friends, "Attractive")
graph_blau_index(marvel_friends, "Gender", "Rich")
graph_ei_index(marvel_friends, "Gender")
graph_ei_index(marvel_friends, "Attractive")
}
