% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blockmodel.R
\name{blockmodel}
\alias{blockmodel}
\alias{blockmodel_concor}
\alias{print.blockmodel}
\title{Blockmodelling}
\source{
\url{https://github.com/aslez/concoR}
}
\usage{
blockmodel_concor(
  object,
  p = 1,
  cutoff = 0.999,
  max.iter = 25,
  block.content = "density"
)

\method{print}{blockmodel}(x, ...)
}
\arguments{
\item{object}{A migraph-consistent object (matrix, igraph, tidygraph).}

\item{p}{An integer representing the desired number of partitions.}

\item{cutoff}{A value between 0 and 1 used to determine convergence.}

\item{max.iter}{An integer representing the maximum number of iterations.}

\item{block.content}{A string indicating which method to use for
calculating block content.
Options are: "density", "sum", "meanrowsum", "meancolsum",
"median", "min", "max".}

\item{x}{An object of class "blockmodel"}

\item{...}{Additional arguments passed to generic print method}
}
\description{
Blockmodelling
}
\examples{
mex_concor <- blockmodel_concor(mpn_elite_mex)
mex_concor
plot(mex_concor)
usa_concor <- blockmodel_concor(mpn_elite_usa_advice)
usa_concor
plot(usa_concor)
}
\references{
Breiger, R.L., Boorman, S.A., and Arabie, P.  1975.
An Algorithm for Clustering Relational Data with Applications to
Social Network Analysis and Comparison with Multidimensional Scaling.
\emph{Journal of Mathematical Psychology}, 12: 328--383.
}
