% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_closure.R
\name{closure}
\alias{closure}
\alias{network_reciprocity}
\alias{network_transitivity}
\alias{network_equivalency}
\alias{network_congruency}
\title{Measures of network closure}
\usage{
network_reciprocity(object, method = "default")

network_transitivity(object)

network_equivalency(object)

network_congruency(object, object2)
}
\arguments{
\item{object}{A one-mode or two-mode matrix, igraph, or tidygraph}

\item{method}{For reciprocity, either \code{default} or \code{ratio}.
See \code{?igraph::reciprocity}}

\item{object2}{Optionally, a second (two-mode) matrix, igraph, or tidygraph}
}
\description{
These functions offer methods for summarising the closure in configurations
in one-, two-, and three-mode networks.
}
\details{
For one-mode networks, shallow wrappers of igraph versions exist via
\code{network_reciprocity} and \code{network_transitivity}.

For two-mode networks, \code{network_equivalency} calculates the proportion of three-paths in the network
that are closed by fourth tie to establish a "shared four-cycle" structure.

For three-mode networks, \code{network_congruency} calculates the proportion of three-paths
spanning two two-mode networks that are closed by a fourth tie to establish a
"congruent four-cycle" structure.
}
\section{Functions}{
\itemize{
\item \code{network_reciprocity()}: Calculate reciprocity in a (usually directed) network

\item \code{network_transitivity()}: Calculate transitivity in a network

\item \code{network_equivalency()}: Calculate equivalence or reinforcement
in a (usually two-mode) network

\item \code{network_congruency()}: Calculate congruency across two two-mode networks

}}
\examples{
network_reciprocity(ison_southern_women)
network_transitivity(ison_southern_women)
network_equivalency(ison_southern_women)
}
\references{
Robins, Garry L, and Malcolm Alexander. 2004.
Small worlds among interlocking directors: Network structure and distance in bipartite graphs.
\emph{Computational & Mathematical Organization Theory} 10(1): 69–94.
\doi{10.1023/B:CMOT.0000032580.12184.c0}.

Knoke, David, Mario Diani, James Hollway, and Dimitris C Christopoulos. 2021.
\emph{Multimodal Political Networks}.
Cambridge University Press. Cambridge University Press.
\doi{10.1017/9781108985000}
}
\seealso{
Other measures: 
\code{\link{centralisation}},
\code{\link{centrality}},
\code{\link{cohesion}()},
\code{\link{diversity}},
\code{\link{features}},
\code{\link{holes}},
\code{\link{tie_centrality}}
}
\concept{measures}
