% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mig_rlcv}
\alias{mig_rlcv}
\title{Robust likelihood cross-validation for kernel density estimation}
\usage{
mig_rlcv(x, beta, Omega, xsamp, dxsamp)
}
\arguments{
\item{x}{\code{n} by \code{d} matrix of quantiles}

\item{beta}{\code{d} vector \eqn{\boldsymbol{\beta}} defining the half-space through \eqn{\boldsymbol{\beta}^{\top}\boldsymbol{\xi}>0}}

\item{Omega}{\code{d} by \code{d} positive definite scale matrix \eqn{\boldsymbol{\Omega}}}

\item{xsamp}{matrix of points at which to evaluate the integral}

\item{dxsamp}{density of points}
}
\value{
the value of the likelihood cross-validation criterion
}
\description{
Given a data matrix over a half-space defined by \code{beta},
compute the log density using leave-one-out cross validation,
taking in turn an observation as location vector and computing the
density of the resulting mixture.
}
