% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mies_methods.R
\name{mies_prime_operators}
\alias{mies_prime_operators}
\title{Prime MIES Operators}
\usage{
mies_prime_operators(
  search_space,
  mutators = list(),
  recombinators = list(),
  selectors = list(),
  filtors = list(),
  ...,
  additional_components = NULL,
  budget_id = NULL
)
}
\arguments{
\item{search_space}{(\code{\link[paradox:ParamSet]{ParamSet}})\cr
Search space of the \code{\link[bbotk:Objective]{Objective}} or \code{\link[bbotk:OptimInstance]{OptimInstance}} to be optimized.}

\item{mutators}{(\code{list} of \code{\link{Mutator}})\cr
\code{\link{Mutator}} objects to prime. May be empty (default).}

\item{recombinators}{(\code{list} of \code{\link{Recombinator}})\cr
\code{\link{Recombinator}} objects to prime. May be empty (default).}

\item{selectors}{(\code{list} of \code{\link{Selector}})\cr
\code{\link{Selector}} objects to prime. May be empty (default).}

\item{filtors}{(\code{list} of \code{\link{Filtor}})\cr
\code{\link{Filtor}} objects to prime. May be empty (default).}

\item{...}{(any)\cr
Must not be given. Other operators may be added in the future, so the following arguments should be passed by name.}

\item{additional_components}{(\code{\link[paradox:ParamSet]{ParamSet}} | \code{NULL})\cr
Additional components to optimize over, not included in \code{search_space}, but possibly used for self-adaption. This must be the \code{\link[paradox:ParamSet]{ParamSet}}
of \code{mies_init_population()}'s \code{additional_component_sampler} argument.}

\item{budget_id}{(\code{character(1)} | \code{NULL})\cr
Budget component used for multi-fidelity optimization.}
}
\value{
\code{invisible} named \code{list} with entries \verb{$mutators} (\code{list} of \code{\link{Mutator}}, primed \code{mutators}), \verb{$recombinators} (\code{list} of \code{\link{Recombinator}}, primed \code{recombinators}),
and \verb{$selectors} (\code{list} of \code{\link{Selector}}, primed \code{selectors}).
}
\description{
Prime the given \code{\link{MiesOperator}}s for an optimization run with the given search space.

In its simplest form, MIES optimization only optimizes the search space of the \code{\link[bbotk:Objective]{Objective}} to be optimized. However,
more advanced optimization may handle a "budget" parameter for multi-fidelity optimization differently: It is still selected by \code{\link{Selector}}s,
but not mutated or recombined and instead handled separately. It is also possible to add additional components to the search space that are
not evaluated by the objective function, but that are used for self-adaption by other operators.

The \code{mies_prime_operators()} function uses the information that the user usually has readily at hand -- the \code{\link[bbotk:Objective]{Objective}}\verb{s search space, the budget parameter, and additional components -- and primes [}Mutator\verb{], [}Recombinator\verb{], and [}Selector`] objects in the right way:
\itemize{
\item \code{\link{Selector}}s are primed on a union of \code{search_space} and \code{additional_components}
\item \code{\link{Mutator}}s and \code{\link{Recombinator}}s are primed on the \code{\link{Selector}}'s space with the \code{budget_id} \code{\link[paradox:Param]{Param}} removed.
}

\code{mies_prime_operators()} is called with an arbitrary number of \code{\link{MiesOperator}} arguments; typically one \code{\link{Mutator}}, one \code{\link{Recombinator}} and
at least two \code{\link{Selector}}: one for survival selection, and one parent selection. Supplied \code{\link{MiesOperator}}s are primed by-reference, but
they are also returned as \link{invisible} \code{list}.

If neither additional components nor multi-fidelity optimization is used, it is also possible to use the \verb{$prime()} function of hte \code{\link{MiesOperator}}s
directly, although using \code{mies_prime_operators()} gives flexibility for future extension.
}
\examples{
# Search space of a potential TuningInstance for optimization:
search_space = ps(x = p_dbl(), y = p_dbl())
# Additoinal search space components that are not part of the TuningInstance
additional_components = ps(z = p_dbl())
# Budget parameter not subject to mutation or recombination
budget_id = "y"

m = mut("gauss")
r = rec("xounif")
s1 = sel("best")
s2 = sel("random")
f = ftr("null")

mies_prime_operators(search_space, mutators = list(m),
  recombinators = list(r), selectors = list(s1, s2), filtors = list(f),
  additional_components = additional_components, budget_id = budget_id
)

# contain search_space without budget parameter, with additional_components
m$primed_ps
r$primed_ps

# contain also the budget parameter
s1$primed_ps
s2$primed_ps
f$primed_ps
}
