% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mid_importance.R
\name{mid.importance}
\alias{mid.importance}
\title{Calculate MID Importance}
\usage{
mid.importance(object, data = NULL, weights = NULL, sort = TRUE, measure = 1L)
}
\arguments{
\item{object}{a "mid" object.}

\item{data}{a data frame containing the observations to calculate the importance. If \code{NULL}, the \code{fitted.matrix} from the "mid" object is used.}

\item{weights}{an optional numeric vector of sample weights.}

\item{sort}{logical. If \code{TRUE}, the output data frame is sorted by importance in descending order.}

\item{measure}{an integer specifying the measure of importance. Possible alternatives are \code{1} for the mean absolute effect, \code{2} for the root mean square effect, and \code{3} for the median absolute effect.}
}
\value{
\code{mid.importance()} returns an object of class "mid.importance". This is a list containing the following components:
\item{importance}{a data frame with the calculated importance values, sorted by default.}
\item{predictions}{the matrix of the fitted or predicted MID values.}
\item{measure}{a character string describing the type of the importance measure used.}
}
\description{
\code{mid.importance()} calculates the MID importance of a fitted MID model.
This is a measure of feature importance that quantifies the average contribution of each component function across a dataset.
}
\details{
The MID importance of a component function (e.g., a main effect or an interaction) is defined as the mean absolute effect on the predictions within the given data.
Terms with higher importance have a larger average impact on the model's overall predictions.
}
\examples{
data(airquality, package = "datasets")
mid <- interpret(Ozone ~ .^2, data = airquality, lambda = 1)

# Calculate MID importance using median absolute contribution
imp <- mid.importance(mid)
print(imp)

# Calculate MID importance using root mean square contribution
imp <- mid.importance(mid, measure = 2)
print(imp)
}
\seealso{
\code{\link{interpret}}, \code{\link{plot.mid.importance}}, \code{\link{ggmid.mid.importance}}
}
