% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/modsel.R
\name{average_forecast}
\alias{average_forecast}
\title{Average forecasts of MIDAS models}
\usage{
average_forecast(modlist, data, insample, outsample, type = c("fixed",
  "recursive", "rolling"), fweights = c("EW", "BICW", "MSFE", "DMSFE"),
  measures = c("MSE", "MAPE", "MASE"), show_progress = TRUE)
}
\arguments{
\item{modlist}{a list of \code{midas_r} objects}

\item{data}{a list with mixed frequency data}

\item{insample}{the low frequency indexes for in-sample data}

\item{outsample}{the low frequency indexes for out-of-sample data}

\item{type}{a string indicating which type of forecast to use.}

\item{fweights}{names of weighting schemes}

\item{measures}{names of accuracy measures}

\item{show_progress}{logical, TRUE to show progress bar, FALSE for silent evaluation}
}
\value{
a list containing forecasts and tables of accuracy measures
}
\description{
Average MIDAS model forecasts using specified weighting scheme. Produce in-sample and out-of-sample accuracy measures.
}
\details{
Given the data, split it to in-sample and out-of-sample data. Then given the list of models, reestimate each model with in-sample data and produce out-of-sample forecast. Given the forecasts average them with the specified weighting scheme. Then calculate the accuracy measures for individual and average forecasts.

The forecasts can be produced in 3 ways. The \code{"fixed"} forecast uses model estimated with in-sample data. The \code{"rolling"} forecast reestimates model each time by increasing the in-sample by one low frequency observation and dropping the first low frequency observation. These reestimated models then are used to produce out-of-sample forecasts. The \code{"recursive"} forecast differs from \code{"rolling"} that it does not drop observations from the beginning of data.
}
\examples{
set.seed(1001)
## Number of low-frequency observations
n<-250
## Linear trend and higher-frequency explanatory variables (e.g. quarterly and monthly)
trend<-c(1:n)
x<-rnorm(4*n)
z<-rnorm(12*n)
## Exponential Almon polynomial constraint-consistent coefficients
fn.x <- nealmon(p=c(1,-0.5),d=8)
fn.z <- nealmon(p=c(2,0.5,-0.1),d=17)
## Simulated low-frequency series (e.g. yearly)
y<-2+0.1*trend+mls(x,0:7,4)\%*\%fn.x+mls(z,0:16,12)\%*\%fn.z+rnorm(n)
mod1 <- midas_r(y ~ trend + mls(x, 4:14, 4, nealmon) + mls(z, 12:22, 12, nealmon),
                start=list(x=c(10,1,-0.1),z=c(2,-0.1)))
mod2 <- midas_r(y ~ trend + mls(x, 4:20, 4, nealmon) + mls(z, 12:25, 12, nealmon),
                start=list(x=c(10,1,-0.1),z=c(2,-0.1)))

##Calculate average forecasts
avgf <- average_forecast(list(mod1,mod2),
                        data=list(y=y,x=x,z=z,trend=trend),
                        insample=1:200,outsample=201:250,
                        type="fixed",
                        measures=c("MSE","MAPE","MASE"),
                        fweights=c("EW","BICW","MSFE","DMSFE"))
}
\author{
Virmantas Kvedaras, Vaidotas Zemlys
}

