% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_sgl.R
\name{sgl_fit}
\alias{sgl_fit}
\title{sg-LASSO regression}
\usage{
sgl_fit(X, Z, y, index, lambdas, gamma_w = NULL, l1_factor = NULL, l21_factor = NULL,
  dummies_index = NULL, inner_iter = NULL, outer_iter = NULL, thresh = NULL, 
  outer_thresh = NULL)
}
\arguments{
\item{X}{T by p data matrix, where t and p respectively denote the sample size and the number of regressors.}

\item{Z}{dummies matrix.}

\item{y}{T by 1 vector of outcome.}

\item{index}{p by 1 vector indicating group membership of each covariate.}

\item{lambdas}{user specified sequence of \eqn{\lambda} values for fitting. We recommend leaving this to NULL and letting function to self-select values.}

\item{gamma_w}{sg-LASSO mixing parameter. \code{gamma_w = 1} is LASSO and \code{gamma_w = 0} group LASSO.}

\item{l1_factor}{\ifelse{html}{\out{&#8467;<sub>1</sub> norm penalty factor for random or fixed effects (default value is zero which means &alpha; is left unpenalized in &#8467;<sub>1</sub> norm).}}{\eqn{\ell_1} norm penalty factor for random or fixed effects (default value is zero which means \eqn{\alpha} is left unpenalized in \eqn{\ell_1} norm).}}

\item{l21_factor}{\ifelse{html}{\out{&#8467;<sub>2,1</sub> norm penalty factor for random or fixed effects (default value is zero which means &alpha; is left unpenalized in &#8467;<sub>2,1</sub> norm).}}{\eqn{\ell_1} norm penalty factor for random or fixed effects (default value is zero which means \eqn{\alpha} is left unpenalized in \eqn{\ell_1} norm).}}

\item{dummies_index}{vector indicating group membership of \eqn{\alpha} (default - no grouping).}

\item{inner_iter}{the maximum number of inner sg-LASSO loop iterations. We recommend leaving this to NULL.}

\item{outer_iter}{the maximum number of outer sg-LASSO loop iterations. We recommend leaving this to NULL.}

\item{thresh}{convergence threshold for change in beta. We recommend leaving this to NULL.}

\item{outer_thresh}{outer loop convergence threshold. We recommend leaving this to NULL.}
}
\value{
sg-LASSO regression fitted coefficients.
}
\description{
Fits mse sg-LASSO regression model.
}
\details{
\ifelse{html}{\out{The sequence of linear regression models implied by <code>lambdas</code> vector is fit by block coordinate-descent. The objective function is <br><br> <center> RSS(&alpha;,&beta;)/T + 2&lambda;  &Omega;<sub>&gamma;</sub>(&beta;), </center> <br> where RSS(&alpha;,&beta;) is the least squares fit. The penalty function &Omega;<sub>&gamma;</sub>(.) is applied on  &beta; coefficients and is <br> <br> <center> &Omega;<sub>&gamma;</sub>(&beta;) = &gamma; |&beta;|<sub>1</sub> + (1-&gamma;)||&beta;||<sub>2,1</sub>, </center> <br> a convex combination of LASSO and group LASSO penalty functions.}}{The sequence of linear regression models implied by \code{lambdas} vector is fit by block coordinate-descent. The objective function is \deqn{RSS(\alpha,\beta)/T + 2\lambda * \Omega_\gamma(\beta),} where \eqn{RSS(\alpha,\beta)} is the least squares fit. The penalty function \eqn{\Omega_\gamma(.)} is applied on \eqn{\beta} coefficients and is \deqn{\Omega_\gamma(\beta) = \gamma |\beta|_1 + (1-\gamma)||\beta||_{2,1},} a convex combination of LASSO and group LASSO penalty functions.}
}
\examples{
set.seed(1)
x = matrix(rnorm(100 * 20), 100, 20)
y = rnorm(100)
index = 1:20
Z <- as.matrix(rep(1,times=length(y)))
sgl_fit(X = x, Z = Z, y = y, index = index, lambdas = c(1,2,3), gamma_w = 1)
}
\author{
Jonas Striaukas
}
