% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_abund.R
\name{trans_abund}
\alias{trans_abund}
\title{Create trans_abund object to transform taxonomic abundance for plotting.}
\description{
This class is a wrapper for the taxonomic abundance transformations and plotting. 
The transformed data style is the long-format for ggplot2 plotting.
The plotting approaches include the bar plot, boxplot, heatmap and pie chart based on An et al. (2019) <doi:10.1016/j.geoderma.2018.09.035>.
}
\examples{

## ------------------------------------------------
## Method `trans_abund$new`
## ------------------------------------------------

\donttest{
data(dataset)
t1 <- trans_abund$new(dataset = dataset, taxrank = "Phylum", ntaxa = 10)
}

## ------------------------------------------------
## Method `trans_abund$plot_bar`
## ------------------------------------------------

\donttest{
t1$plot_bar(facet = "Group", xtext_keep = FALSE)
}

## ------------------------------------------------
## Method `trans_abund$plot_heatmap`
## ------------------------------------------------

\donttest{
t1 <- trans_abund$new(dataset = dataset, taxrank = "Genus", ntaxa = 40)
t1$plot_heatmap(facet = "Group", xtext_keep = FALSE, withmargin = FALSE)
}

## ------------------------------------------------
## Method `trans_abund$plot_box`
## ------------------------------------------------

\donttest{
t1$plot_box(group = "Group")
}

## ------------------------------------------------
## Method `trans_abund$plot_pie`
## ------------------------------------------------

\donttest{
t1 <- trans_abund$new(dataset = dataset, taxrank = "Phylum", ntaxa = 6, groupmean = "Group")
t1$plot_pie(facet_nrow = 1)
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{trans_abund$new()}}
\item \href{#method-plot_bar}{\code{trans_abund$plot_bar()}}
\item \href{#method-plot_heatmap}{\code{trans_abund$plot_heatmap()}}
\item \href{#method-plot_box}{\code{trans_abund$plot_box()}}
\item \href{#method-plot_pie}{\code{trans_abund$plot_pie()}}
\item \href{#method-print}{\code{trans_abund$print()}}
\item \href{#method-clone}{\code{trans_abund$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_abund$new(
  dataset = NULL,
  taxrank = "Phylum",
  show = 0,
  ntaxa = 10,
  groupmean = NULL,
  delete_full_prefix = TRUE,
  delete_part_prefix = FALSE,
  prefix = NULL,
  use_percentage = TRUE,
  input_taxaname = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{default NULL; microtable object.}

\item{\code{taxrank}}{default "Phylum"; taxonomic rank.}

\item{\code{show}}{default 0; the relative abundance threshold used for filtering.}

\item{\code{ntaxa}}{default 10; how many taxa will be used, ordered by abundance from high to low; 
this parameter does not conflict with the parameter show; both can be used.}

\item{\code{groupmean}}{default NULL; calculating mean abundance for each group, select a group column name in sample_table.}

\item{\code{delete_full_prefix}}{default TRUE; whether delete both the prefix and the character in front of them.}

\item{\code{delete_part_prefix}}{default FALSE; whether only delete the prefix.}

\item{\code{prefix}}{default NULL; character string; can be used when delete_full_prefix = T or delete_part_prefix = T; 
default NULL reprensents using the "letter+__", e.g. "k__" for Phylum level.}

\item{\code{use_percentage}}{default TRUE; show the abundance percentage.}

\item{\code{input_taxaname}}{default NULL; character vector; if some taxa are selected, input taxa names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
abund_data for plotting.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
data(dataset)
t1 <- trans_abund$new(dataset = dataset, taxrank = "Phylum", ntaxa = 10)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_bar"></a>}}
\if{latex}{\out{\hypertarget{method-plot_bar}{}}}
\subsection{Method \code{plot_bar()}}{
Bar plot in trans_abund object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_abund$plot_bar(
  use_colors = RColorBrewer::brewer.pal(12, "Paired"),
  bar_type = "full",
  others_color = "grey90",
  facet = NULL,
  facet2 = NULL,
  order_facet = NULL,
  x_axis_name = NULL,
  order_x = NULL,
  barwidth = NULL,
  use_alluvium = FALSE,
  clustering = FALSE,
  facet_color = "grey95",
  strip_text = 11,
  legend_text_italic = FALSE,
  xtext_type_hor = TRUE,
  xtext_size = 10,
  xtext_keep = TRUE,
  xtitle_keep = TRUE,
  ytitle_size = 17,
  base_font = NULL,
  ylab_title = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_colors}}{default RColorBrewer::brewer.pal(12, "Paired"); providing the plotting colors.}

\item{\code{bar_type}}{default "full"; "full" or "notfull"; if full, the total abundance sum to 1 or 100 percentage.}

\item{\code{others_color}}{default "grey90"; the color for "others" taxa.}

\item{\code{facet}}{default NULL; if using facet, providing a group column name of sample_table, such as, "Group".}

\item{\code{facet2}}{default NULL; the second facet, used with facet parameter together; facet2 should have a finer scale;
use this parameter, please first install package ggh4x using install.packages("ggh4x")}

\item{\code{order_facet}}{NULL; vector; used to order the facet, such as, c("Group1", "Group3", "Group2").}

\item{\code{x_axis_name}}{NULL; a character string; a column name of sample_table used to show the sample names in x axis.}

\item{\code{order_x}}{default NULL; vector; used to order the sample names in x axis; must be the samples vector, such as, c("S1", "S3", "S2").}

\item{\code{barwidth}}{default NULL; bar width, see width in \code{\link{geom_bar}}.}

\item{\code{use_alluvium}}{default FALSE; whether add alluvium plot}

\item{\code{clustering}}{default FALSE; whether order samples by the clustering}

\item{\code{facet_color}}{default "grey95"; facet background color.}

\item{\code{strip_text}}{default 11; facet text size.}

\item{\code{legend_text_italic}}{default FALSE; whether use italic in legend.}

\item{\code{xtext_type_hor}}{default TRUE; x axis text horizontal, if FALSE; text slant.}

\item{\code{xtext_size}}{default 10; x axis text size.}

\item{\code{xtext_keep}}{default TRUE; whether retain x text.}

\item{\code{xtitle_keep}}{default TRUE; whether retain x title.}

\item{\code{ytitle_size}}{default 17; y axis title size.}

\item{\code{base_font}}{default NULL; ggplot font family in the plot.}

\item{\code{ylab_title}}{default NULL; y axis title.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot2 plot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_bar(facet = "Group", xtext_keep = FALSE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_heatmap"></a>}}
\if{latex}{\out{\hypertarget{method-plot_heatmap}{}}}
\subsection{Method \code{plot_heatmap()}}{
Plot the heatmap in trans_abund object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_abund$plot_heatmap(
  use_colors = c("#00008B", "#102D9B", "#215AAC", "#3288BD", "#66C2A5", "#E6F598",
    "#FFFFBF", "#FED690", "#FDAE61", "#F46D43", "#D53E4F", "#9E0142"),
  facet = NULL,
  order_facet = NULL,
  x_axis_name = NULL,
  order_x = NULL,
  withmargin = TRUE,
  plot_numbers = FALSE,
  plot_text_size = 4,
  plot_breaks = NULL,
  margincolor = "white",
  plot_colorscale = "log10",
  min_abundance = 0.01,
  max_abundance = NULL,
  strip_text = 11,
  xtext_size = 10,
  ytext_size = 11,
  xtext_keep = TRUE,
  xtitle_keep = TRUE,
  grid_clean = TRUE,
  xtext_type_hor = TRUE,
  base_font = NULL,
  pheatmap = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_colors}}{default RColorBrewer::brewer.pal(12, "Paired"); providing the plotting colors.}

\item{\code{facet}}{default NULL; a character string; if using facet, providing a group column name of sample_table, such as, "Group".}

\item{\code{order_facet}}{NULL; vector; used to order the facet, such as, c("Group1", "Group3", "Group2").}

\item{\code{x_axis_name}}{NULL; a character string; a column name of sample_table used to show the sample names in x axis.}

\item{\code{order_x}}{default NULL; vector; used to order the sample names in x axis; must be the samples vector, such as, c("S1", "S3", "S2").}

\item{\code{withmargin}}{default TRUE; whether retain the tile margin.}

\item{\code{plot_numbers}}{default FALSE; whether plot the number in heatmap.}

\item{\code{plot_text_size}}{default 4; If plot_numbers TRUE, text size in plot.}

\item{\code{plot_breaks}}{default NULL; The legend breaks.}

\item{\code{margincolor}}{default "white"; If withmargin TRUE, use this as the margin color.}

\item{\code{plot_colorscale}}{default "log10"; color scale.}

\item{\code{min_abundance}}{default .01; the minimum abundance percentage in plot.}

\item{\code{max_abundance}}{default NULL; the maximum abundance percentage in plot, NULL reprensent the max percentage.}

\item{\code{strip_text}}{default 11; facet text size.}

\item{\code{xtext_size}}{default 10; x axis text size.}

\item{\code{ytext_size}}{default 11; y axis text size.}

\item{\code{xtext_keep}}{default TRUE; whether retain x text.}

\item{\code{xtitle_keep}}{default TRUE; whether retain x title.}

\item{\code{grid_clean}}{default TRUE; whether remove grid lines.}

\item{\code{xtext_type_hor}}{default TRUE; x axis text horizontal, if FALSE; text slant.}

\item{\code{base_font}}{default NULL; font in the plot.}

\item{\code{pheatmap}}{default FALSE; whether use pheatmap package to plot the heatmap.}

\item{\code{...}}{paremeters pass to pheatmap when pheatmap = TRUE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot2 plot or grid plot based on pheatmap.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1 <- trans_abund$new(dataset = dataset, taxrank = "Genus", ntaxa = 40)
t1$plot_heatmap(facet = "Group", xtext_keep = FALSE, withmargin = FALSE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_box"></a>}}
\if{latex}{\out{\hypertarget{method-plot_box}{}}}
\subsection{Method \code{plot_box()}}{
Box plot in trans_abund object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_abund$plot_box(
  use_colors = RColorBrewer::brewer.pal(8, "Dark2"),
  group = NULL,
  show_point = FALSE,
  point_color = "black",
  point_size = 3,
  point_alpha = 0.3,
  plot_flip = FALSE,
  boxfill = TRUE,
  middlecolor = "grey95",
  middlesize = 1,
  xtext_type_hor = FALSE,
  xtext_size = 10,
  xtext_keep = TRUE,
  xtitle_keep = TRUE,
  ytitle_size = 17,
  base_font = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_colors}}{default RColorBrewer::brewer.pal(12, "Paired"); providing the plotting colors.}

\item{\code{group}}{default NULL; column name of sample table to show abundance across groups.}

\item{\code{show_point}}{default FALSE; whether show points in plot.}

\item{\code{point_color}}{default "black"; If show_point TRUE; use the color}

\item{\code{point_size}}{default 3; If show_point TRUE; use the size}

\item{\code{point_alpha}}{default .3; If show_point TRUE; use the transparency.}

\item{\code{plot_flip}}{default FALSE; Whether rotate plot.}

\item{\code{boxfill}}{default TRUE; Whether fill the box.}

\item{\code{middlecolor}}{default "grey95"; The middle line color.}

\item{\code{middlesize}}{default 1; The middle line size.}

\item{\code{xtext_type_hor}}{default TRUE; x axis text horizontal, if FALSE; text slant.}

\item{\code{xtext_size}}{default 10; x axis text size.}

\item{\code{xtext_keep}}{default TRUE; whether retain x text.}

\item{\code{xtitle_keep}}{default TRUE; whether retain x title.}

\item{\code{ytitle_size}}{default 17; y axis title size.}

\item{\code{base_font}}{default NULL; font in the plot.}

\item{\code{...}}{parameters pass to \code{\link{geom_boxplot}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot2 plot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_box(group = "Group")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_pie"></a>}}
\if{latex}{\out{\hypertarget{method-plot_pie}{}}}
\subsection{Method \code{plot_pie()}}{
Plot pie chart in trans_abund class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_abund$plot_pie(
  use_colors = RColorBrewer::brewer.pal(8, "Dark2"),
  facet_nrow = 1,
  strip_text = 11,
  legend_text_italic = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_colors}}{default RColorBrewer::brewer.pal(8, "Dark2"); providing the plotting colors.}

\item{\code{facet_nrow}}{default 1; how many rows in the plot.}

\item{\code{strip_text}}{default 11; sample title size.}

\item{\code{legend_text_italic}}{default FALSE; whether use italic in legend.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot2 plot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1 <- trans_abund$new(dataset = dataset, taxrank = "Phylum", ntaxa = 6, groupmean = "Group")
t1$plot_pie(facet_nrow = 1)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print the trans_abund object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_abund$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_abund$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
