#' The dataset in the microeco package
#'
#' The dataset is structured with microtable class for the demonstration of examples and tutorials.
#'
#' \itemize{
#'   \item sample_table: sample information table
#'   \item otu_table: species-community abundance table
#'   \item tax_table: taxonomic table
#'   \item phylo_tree: phylogenetic tree
#'   \item taxa_abund: taxa abundance list with several tables for Phylum...Genus
#'   \item alpha_diversity: alpha diversity table
#'   \item beta_diversity: list with several beta diversity distance matrix
#' }
#'
#' @docType data
#' @keywords R6 object
#' @name dataset
#' @usage data(dataset)
#' @format An R6 class object
NULL

#' The environmental factors for the 16S dataset in the microeco package
#'
#'
#' @docType data
#' @keywords data.frame
#' @name env_data_16S
#' @usage data(env_data_16S)
NULL


#' The OTU table of the 16S dataset in the microeco package
#'
#'
#' @docType data
#' @keywords data.frame
#' @name otu_table_16S
#' @usage data(otu_table_16S)
NULL



#' The OTU table of the ITS dataset in the microeco package
#'
#'
#' @docType data
#' @keywords data.frame
#' @name otu_table_ITS
#' @usage data(otu_table_ITS)
NULL


#' The phylogenetic tree of 16S dataset in the microeco package
#'
#'
#' @docType data
#' @keywords data.frame
#' @name phylo_tree_16S
#' @usage data(phylo_tree_16S)
NULL


#' The prokaryotic trait database in the microeco package
#'
#'
#' @docType data
#' @keywords data.frame
#' @name prok_func
#' @usage data(prok_func)
NULL


#' The FUNGuild database for fungi trait identification in the microeco package
#'
#'
#' @docType data
#' @keywords data.frame
#' @name fungi_func_FUNGuild
#' @usage data(fungi_func_FUNGuild)
NULL


#' The FungalTraits database for fungi trait identification in the microeco package
#'
#'
#' @docType data
#' @keywords data.frame
#' @name fungi_func_FungalTraits
#' @usage data(fungi_func_FungalTraits)
NULL


#' The KEGG pathway annotation database in the microeco package
#'
#'
#' @docType data
#' @keywords data.frame
#' @name ko_map
#' @usage data(ko_map)
NULL


#' The sample information of 16S dataset in the microeco package
#'
#'
#' @docType data
#' @keywords data.frame
#' @name sample_info_16S
#' @usage data(sample_info_16S)
NULL



#' The sample information of ITS dataset in the microeco package
#'
#'
#' @docType data
#' @keywords data.frame
#' @name sample_info_ITS
#' @usage data(sample_info_ITS)
NULL


#' The taxonomic information of 16S dataset in the microeco package
#'
#'
#' @docType data
#' @keywords data.frame
#' @name taxonomy_table_16S
#' @usage data(taxonomy_table_16S)
NULL



#' The taxonomic information of ITS dataset in the microeco package
#'
#'
#' @docType data
#' @keywords data.frame
#' @name taxonomy_table_ITS
#' @usage data(taxonomy_table_ITS)
NULL





