% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blast.R
\name{blastDbase16S}
\alias{blastDbase16S}
\title{Building a BLAST database}
\usage{
blastDbase16S(name, sequence, taxon)
}
\arguments{
\item{name}{The name of the database (text).}

\item{sequence}{A character vector with 16S sequence data.}

\item{taxon}{A character vector with taxon information.}
}
\value{
The database files are created, and the name of the database (\code{name}) is returned.
}
\description{
Building a BLAST database for 16S based classification.
}
\details{
This functions builds a database using the \code{makeblastdb} program of the
BLAST+ software \url{https://blast.ncbi.nlm.nih.gov/Blast.cgi?PAGE_TYPE=BlastDocs&DOC_TYPE=Download}.
Thus, this software must be available on the system when using this
function. If you type \code{system("makeblastdb -help")} in the Console window some meaningful
Help-text should be displayed.

This function is most typically used prior to \code{\link{blastClassify16S}} to set up the database
before searching and classifying. It can be seen as the 'training step' of a BLAST-based
classification procedure.

The \code{sequence} must be a vector of DNA-sequences (16S sequences). The \code{taxon} is a vector of the same 
length as \code{sequence}, containing the correpsonding taxon information.
}
\examples{
# See examples for blastClassify16S.

}
\seealso{
\code{\link{blastClassify16S}}.
}
\author{
Lars Snipen.
}
