% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmpoutput.R
\name{assumptions.cmpoutput}
\alias{assumptions.cmpoutput}
\title{Get assumptions for parametric tests performed on output comparisons}
\usage{
\method{assumptions}{cmpoutput}(obj)
}
\arguments{
\item{obj}{Object of class \code{cmpoutput}.}
}
\value{
Object of class \code{assumptions_cmpoutput} containing the
assumptions for parametric tests performed on an output comparison.
Basically a list containing the assumptions for the MANOVA (list of objects
of class \code{\link{assumptions_manova}}, one per explained variance) and
univariate parametric tests for each principal component (object of class
\code{\link{assumptions_paruv}}).
}
\description{
Get assumptions for parametric tests performed on output comparisons (i.e.
from objects of class \code{\link{cmpoutput}}).
}
\examples{

# Create a cmpoutput object from the provided datasets
cmp <- cmpoutput("All", 0.9, pphpc_ok$data[["All"]], pphpc_ok$obs_lvls)

# Get the assumptions for the parametric tests performed in cmp
acmp <- assumptions(cmp)

}
