% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KM2_plots.R
\name{plotKM2.3D}
\alias{plotKM2.3D}
\title{Uses a 3D perspective plot to visualize a bivariate survival function}
\usage{
plotKM2.3D(
  km2.obj,
  col = "grey",
  shade = 0.25,
  theta = 120,
  xlab = "T1",
  ylab = "T2",
  zlab = "Fhat",
  ...
)
}
\arguments{
\item{km2.obj}{Output of the KM2 function.}

\item{col}{Color palette to be used for the plot. Defaults to "grey".
See persp3D.}

\item{shade}{The degree of shading of the surface facets. Defaults to
0.25. See persp.}

\item{theta}{The azimuthal viewing direction. See persp.}

\item{xlab}{The x-axis label. Defaults to "T1".}

\item{ylab}{The y-axis label. Defaults to "T2".}

\item{zlab}{The z-axis label. Defaults to "Fhat".}

\item{...}{Additional parameters to the persp3D function.}
}
\description{
Plots a 3D perspective plot of an estimated bivariate survival
function. This function is a wrapper for the persp3D function
from the plot3D package with default parameters chosen to make the
data easier to visualize.
}
\examples{
x <- genClayton2(1000, 0, 1, 1, 2, 2)
x.km2 <- KM2(x$Y1, x$Y2, x$Delta1, x$Delta2)
\donttest{plotKM2.3D(x.km2)}

x2 <- genClayton2(1000, 2, 1, 1, 2, 2)
x2.km2 <- KM2(x2$Y1, x2$Y2, x2$Delta1, x2$Delta2)
\donttest{plotKM2.3D(x2.km2)}
}
\seealso{
\code{\link{KM2}}, \code{\link[plot3D]{persp3D}}
}
